@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property action Action to take if a match is determined.
 * @property match Criteria for determining an HTTP request match.
 * @property retryPolicy Retry policy.
 * @property timeout Types of timeouts.
 */
public data class RouteSpecHttpRoute(
    public val action: RouteSpecHttpRouteAction,
    public val match: RouteSpecHttpRouteMatch,
    public val retryPolicy: RouteSpecHttpRouteRetryPolicy? = null,
    public val timeout: RouteSpecHttpRouteTimeout? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttpRoute): RouteSpecHttpRoute = RouteSpecHttpRoute(
            action = javaType.action().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteAction.Companion.toKotlin(args0)
            }),
            match = javaType.match().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteMatch.Companion.toKotlin(args0)
            }),
            retryPolicy = javaType.retryPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteRetryPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            timeout = javaType.timeout().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteTimeout.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
