@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property headers Client request headers to match on.
 * @property method Client request header method to match on. Valid values: `GET`, `HEAD`, `POST`, `PUT`, `DELETE`, `CONNECT`, `OPTIONS`, `TRACE`, `PATCH`.
 * @property path Client request path to match on.
 * @property port The port number to match from the request.
 * @property prefix Path with which to match requests.
 * This parameter must always start with /, which by itself matches all requests to the virtual router service name.
 * @property queryParameters Client request query parameters to match on.
 * @property scheme Client request header scheme to match on. Valid values: `http`, `https`.
 */
public data class RouteSpecHttpRouteMatch(
    public val headers: List<RouteSpecHttpRouteMatchHeader>? = null,
    public val method: String? = null,
    public val path: RouteSpecHttpRouteMatchPath? = null,
    public val port: Int? = null,
    public val prefix: String? = null,
    public val queryParameters: List<RouteSpecHttpRouteMatchQueryParameter>? = null,
    public val scheme: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttpRouteMatch): RouteSpecHttpRouteMatch = RouteSpecHttpRouteMatch(
            headers = javaType.headers().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteMatchHeader.Companion.toKotlin(args0)
                })
            }),
            method = javaType.method().map({ args0 -> args0 }).orElse(null),
            path = javaType.path().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteMatchPath.Companion.toKotlin(args0)
                })
            }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            prefix = javaType.prefix().map({ args0 -> args0 }).orElse(null),
            queryParameters = javaType.queryParameters().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteMatchQueryParameter.Companion.toKotlin(args0)
                })
            }),
            scheme = javaType.scheme().map({ args0 -> args0 }).orElse(null),
        )
    }
}
