@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property httpRetryEvents List of HTTP retry events.
 * Valid values: `client-error` (HTTP status code 409), `gateway-error` (HTTP status codes 502, 503, and 504), `server-error` (HTTP status codes 500, 501, 502, 503, 504, 505, 506, 507, 508, 510, and 511), `stream-error` (retry on refused stream).
 * @property maxRetries Maximum number of retries.
 * @property perRetryTimeout Per-retry timeout.
 * @property tcpRetryEvents List of TCP retry events. The only valid value is `connection-error`.
 * You must specify at least one value for `http_retry_events`, or at least one value for `tcp_retry_events`.
 */
public data class RouteSpecHttpRouteRetryPolicy(
    public val httpRetryEvents: List<String>? = null,
    public val maxRetries: Int,
    public val perRetryTimeout: RouteSpecHttpRouteRetryPolicyPerRetryTimeout,
    public val tcpRetryEvents: List<String>? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.RouteSpecHttpRouteRetryPolicy): RouteSpecHttpRouteRetryPolicy = RouteSpecHttpRouteRetryPolicy(
            httpRetryEvents = javaType.httpRetryEvents().map({ args0 -> args0 }),
            maxRetries = javaType.maxRetries(),
            perRetryTimeout = javaType.perRetryTimeout().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.RouteSpecHttpRouteRetryPolicyPerRetryTimeout.Companion.toKotlin(args0)
            }),
            tcpRetryEvents = javaType.tcpRetryEvents().map({ args0 -> args0 }),
        )
    }
}
