@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress
import kotlin.collections.List

/**
 *
 * @property backendDefaults Defaults for backends.
 * @property listeners Listeners that the mesh endpoint is expected to receive inbound traffic from. You can specify one listener.
 * @property logging Inbound and outbound access logging information for the virtual gateway.
 */
public data class VirtualGatewaySpec(
    public val backendDefaults: VirtualGatewaySpecBackendDefaults? = null,
    public val listeners: List<VirtualGatewaySpecListener>,
    public val logging: VirtualGatewaySpecLogging? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpec): VirtualGatewaySpec = VirtualGatewaySpec(
            backendDefaults = javaType.backendDefaults().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaults.Companion.toKotlin(args0)
                })
            }).orElse(null),
            listeners = javaType.listeners().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListener.Companion.toKotlin(args0)
                })
            }),
            logging = javaType.logging().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecLogging.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
