@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property subjectAlternativeNames SANs for a virtual gateway's listener's Transport Layer Security (TLS) validation context.
 * @property trust TLS validation context trust.
 */
public data class VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidation(
    public val subjectAlternativeNames: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNames? = null,
    public val trust: VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrust,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidation): VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidation =
            VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidation(
                subjectAlternativeNames = javaType.subjectAlternativeNames().map({ args0 ->
                    args0.let({ args0 ->
                        com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationSubjectAlternativeNames.Companion.toKotlin(args0)
                    })
                }).orElse(null),
                trust = javaType.trust().let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecBackendDefaultsClientPolicyTlsValidationTrust.Companion.toKotlin(args0)
                }),
            )
    }
}
