@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property connectionPool Connection pool information for the listener.
 * @property healthCheck Health check information for the listener.
 * @property portMapping Port mapping information for the listener.
 * @property tls Transport Layer Security (TLS) properties for the listener
 */
public data class VirtualGatewaySpecListener(
    public val connectionPool: VirtualGatewaySpecListenerConnectionPool? = null,
    public val healthCheck: VirtualGatewaySpecListenerHealthCheck? = null,
    public val portMapping: VirtualGatewaySpecListenerPortMapping,
    public val tls: VirtualGatewaySpecListenerTls? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecListener): VirtualGatewaySpecListener = VirtualGatewaySpecListener(
            connectionPool = javaType.connectionPool().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerConnectionPool.Companion.toKotlin(args0)
                })
            }).orElse(null),
            healthCheck = javaType.healthCheck().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerHealthCheck.Companion.toKotlin(args0)
                })
            }).orElse(null),
            portMapping = javaType.portMapping().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerPortMapping.Companion.toKotlin(args0)
            }),
            tls = javaType.tls().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTls.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
