@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property certificate Listener's TLS certificate.
 * @property mode Listener's TLS mode. Valid values: `DISABLED`, `PERMISSIVE`, `STRICT`.
 * @property validation Listener's Transport Layer Security (TLS) validation context.
 */
public data class VirtualGatewaySpecListenerTls(
    public val certificate: VirtualGatewaySpecListenerTlsCertificate,
    public val mode: String,
    public val validation: VirtualGatewaySpecListenerTlsValidation? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualGatewaySpecListenerTls): VirtualGatewaySpecListenerTls = VirtualGatewaySpecListenerTls(
            certificate = javaType.certificate().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsCertificate.Companion.toKotlin(args0)
            }),
            mode = javaType.mode(),
            validation = javaType.validation().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualGatewaySpecListenerTlsValidation.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
