@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property clientPolicy Client policy for the backend.
 * @property virtualServiceName Name of the virtual service that is acting as a virtual node backend. Must be between 1 and 255 characters in length.
 */
public data class VirtualNodeSpecBackendVirtualService(
    public val clientPolicy: VirtualNodeSpecBackendVirtualServiceClientPolicy? = null,
    public val virtualServiceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecBackendVirtualService): VirtualNodeSpecBackendVirtualService = VirtualNodeSpecBackendVirtualService(
            clientPolicy = javaType.clientPolicy().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecBackendVirtualServiceClientPolicy.Companion.toKotlin(args0)
                })
            }).orElse(null),
            virtualServiceName = javaType.virtualServiceName(),
        )
    }
}
