@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.String
import kotlin.Suppress

/**
 *
 * @property healthyThreshold Number of consecutive successful health checks that must occur before declaring listener healthy.
 * @property intervalMillis Time period in milliseconds between each health check execution.
 * @property path Destination path for the health check request. This is only required if the specified protocol is `http` or `http2`.
 * @property port Destination port for the health check request. This port must match the port defined in the `port_mapping` for the listener.
 * @property protocol Protocol for the health check request. Valid values are `http`, `http2`, `tcp` and `grpc`.
 * @property timeoutMillis Amount of time to wait when receiving a response from the health check, in milliseconds.
 * @property unhealthyThreshold Number of consecutive failed health checks that must occur before declaring a virtual node unhealthy.
 */
public data class VirtualNodeSpecListenerHealthCheck(
    public val healthyThreshold: Int,
    public val intervalMillis: Int,
    public val path: String? = null,
    public val port: Int? = null,
    public val protocol: String,
    public val timeoutMillis: Int,
    public val unhealthyThreshold: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerHealthCheck): VirtualNodeSpecListenerHealthCheck = VirtualNodeSpecListenerHealthCheck(
            healthyThreshold = javaType.healthyThreshold(),
            intervalMillis = javaType.intervalMillis(),
            path = javaType.path().map({ args0 -> args0 }).orElse(null),
            port = javaType.port().map({ args0 -> args0 }).orElse(null),
            protocol = javaType.protocol(),
            timeoutMillis = javaType.timeoutMillis(),
            unhealthyThreshold = javaType.unhealthyThreshold(),
        )
    }
}
