@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Int
import kotlin.Suppress

/**
 *
 * @property baseEjectionDuration Base amount of time for which a host is ejected.
 * @property interval Time interval between ejection sweep analysis.
 * @property maxEjectionPercent Maximum percentage of hosts in load balancing pool for upstream service that can be ejected. Will eject at least one host regardless of the value.
 * Minimum value of `0`. Maximum value of `100`.
 * @property maxServerErrors Number of consecutive `5xx` errors required for ejection. Minimum value of `1`.
 */
public data class VirtualNodeSpecListenerOutlierDetection(
    public val baseEjectionDuration: VirtualNodeSpecListenerOutlierDetectionBaseEjectionDuration,
    public val interval: VirtualNodeSpecListenerOutlierDetectionInterval,
    public val maxEjectionPercent: Int,
    public val maxServerErrors: Int,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerOutlierDetection): VirtualNodeSpecListenerOutlierDetection = VirtualNodeSpecListenerOutlierDetection(
            baseEjectionDuration = javaType.baseEjectionDuration().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerOutlierDetectionBaseEjectionDuration.Companion.toKotlin(args0)
            }),
            interval = javaType.interval().let({ args0 ->
                com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerOutlierDetectionInterval.Companion.toKotlin(args0)
            }),
            maxEjectionPercent = javaType.maxEjectionPercent(),
            maxServerErrors = javaType.maxServerErrors(),
        )
    }
}
