@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.Suppress

/**
 *
 * @property grpc Timeouts for gRPC listeners.
 * @property http Timeouts for HTTP listeners.
 * @property http2 Timeouts for HTTP2 listeners.
 * @property tcp Timeouts for TCP listeners.
 */
public data class VirtualNodeSpecListenerTimeout(
    public val grpc: VirtualNodeSpecListenerTimeoutGrpc? = null,
    public val http: VirtualNodeSpecListenerTimeoutHttp? = null,
    public val http2: VirtualNodeSpecListenerTimeoutHttp2? = null,
    public val tcp: VirtualNodeSpecListenerTimeoutTcp? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecListenerTimeout): VirtualNodeSpecListenerTimeout = VirtualNodeSpecListenerTimeout(
            grpc = javaType.grpc().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTimeoutGrpc.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http = javaType.http().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTimeoutHttp.Companion.toKotlin(args0)
                })
            }).orElse(null),
            http2 = javaType.http2().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTimeoutHttp2.Companion.toKotlin(args0)
                })
            }).orElse(null),
            tcp = javaType.tcp().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecListenerTimeoutTcp.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
