@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property format The specified format for the logs.
 * @property path File path to write access logs to. You can use `/dev/stdout` to send access logs to standard out. Must be between 1 and 255 characters in length.
 */
public data class VirtualNodeSpecLoggingAccessLogFile(
    public val format: VirtualNodeSpecLoggingAccessLogFileFormat? = null,
    public val path: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecLoggingAccessLogFile): VirtualNodeSpecLoggingAccessLogFile = VirtualNodeSpecLoggingAccessLogFile(
            format = javaType.format().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.appmesh.kotlin.outputs.VirtualNodeSpecLoggingAccessLogFileFormat.Companion.toKotlin(args0)
                })
            }).orElse(null),
            path = javaType.path(),
        )
    }
}
