@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property attributes String map that contains attributes with values that you can use to filter instances by any custom attribute that you specified when you registered the instance. Only instances that match all of the specified key/value pairs will be returned.
 * @property namespaceName Name of the AWS Cloud Map namespace to use.
 * Use the `aws.servicediscovery.HttpNamespace` resource to configure a Cloud Map namespace. Must be between 1 and 1024 characters in length.
 * @property serviceName Name of the AWS Cloud Map service to use. Use the `aws.servicediscovery.Service` resource to configure a Cloud Map service. Must be between 1 and 1024 characters in length.
 */
public data class VirtualNodeSpecServiceDiscoveryAwsCloudMap(
    public val attributes: Map<String, String>? = null,
    public val namespaceName: String,
    public val serviceName: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecServiceDiscoveryAwsCloudMap): VirtualNodeSpecServiceDiscoveryAwsCloudMap = VirtualNodeSpecServiceDiscoveryAwsCloudMap(
            attributes = javaType.attributes().map({ args0 -> args0.key.to(args0.value) }).toMap(),
            namespaceName = javaType.namespaceName(),
            serviceName = javaType.serviceName(),
        )
    }
}
