@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appmesh.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property hostname DNS host name for your virtual node.
 * @property ipPreference The preferred IP version that this virtual node uses. Valid values: `IPv6_PREFERRED`, `IPv4_PREFERRED`, `IPv4_ONLY`, `IPv6_ONLY`.
 * @property responseType The DNS response type for the virtual node. Valid values: `LOADBALANCER`, `ENDPOINTS`.
 */
public data class VirtualNodeSpecServiceDiscoveryDns(
    public val hostname: String,
    public val ipPreference: String? = null,
    public val responseType: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.appmesh.outputs.VirtualNodeSpecServiceDiscoveryDns): VirtualNodeSpecServiceDiscoveryDns = VirtualNodeSpecServiceDiscoveryDns(
            hostname = javaType.hostname(),
            ipPreference = javaType.ipPreference().map({ args0 -> args0 }).orElse(null),
            responseType = javaType.responseType().map({ args0 -> args0 }).orElse(null),
        )
    }
}
