@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map

/**
 * Builder for [AutoScalingConfigurationVersion].
 */
@PulumiTagMarker
public class AutoScalingConfigurationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: AutoScalingConfigurationVersionArgs = AutoScalingConfigurationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend AutoScalingConfigurationVersionArgsBuilder.() -> Unit) {
        val builder = AutoScalingConfigurationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): AutoScalingConfigurationVersion {
        val builtJavaResource =
            com.pulumi.aws.apprunner.AutoScalingConfigurationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return AutoScalingConfigurationVersion(builtJavaResource)
    }
}

/**
 * Manages an App Runner AutoScaling Configuration Version.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.AutoScalingConfigurationVersion("example", {
 *     autoScalingConfigurationName: "example",
 *     maxConcurrency: 50,
 *     maxSize: 10,
 *     minSize: 2,
 *     tags: {
 *         Name: "example-apprunner-autoscaling",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.AutoScalingConfigurationVersion("example",
 *     auto_scaling_configuration_name="example",
 *     max_concurrency=50,
 *     max_size=10,
 *     min_size=2,
 *     tags={
 *         "Name": "example-apprunner-autoscaling",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.AutoScalingConfigurationVersion("example", new()
 *     {
 *         AutoScalingConfigurationName = "example",
 *         MaxConcurrency = 50,
 *         MaxSize = 10,
 *         MinSize = 2,
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-autoscaling" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewAutoScalingConfigurationVersion(ctx, "example", &apprunner.AutoScalingConfigurationVersionArgs{
 * 			AutoScalingConfigurationName: pulumi.String("example"),
 * 			MaxConcurrency:               pulumi.Int(50),
 * 			MaxSize:                      pulumi.Int(10),
 * 			MinSize:                      pulumi.Int(2),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-autoscaling"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersion;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AutoScalingConfigurationVersion("example", AutoScalingConfigurationVersionArgs.builder()
 *             .autoScalingConfigurationName("example")
 *             .maxConcurrency(50)
 *             .maxSize(10)
 *             .minSize(2)
 *             .tags(Map.of("Name", "example-apprunner-autoscaling"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:AutoScalingConfigurationVersion
 *     properties:
 *       autoScalingConfigurationName: example
 *       maxConcurrency: 50
 *       maxSize: 10
 *       minSize: 2
 *       tags:
 *         Name: example-apprunner-autoscaling
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner AutoScaling Configuration Versions using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:apprunner/autoScalingConfigurationVersion:AutoScalingConfigurationVersion example "arn:aws:apprunner:us-east-1:1234567890:autoscalingconfiguration/example/1/69bdfe0115224b0db49398b7beb68e0f
 * ```
 */
public class AutoScalingConfigurationVersion internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.AutoScalingConfigurationVersion,
) : KotlinCustomResource(javaResource, AutoScalingConfigurationVersionMapper) {
    /**
     * ARN of this auto scaling configuration version.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Name of the auto scaling configuration.
     */
    public val autoScalingConfigurationName: Output<String>
        get() = javaResource.autoScalingConfigurationName().applyValue({ args0 -> args0 })

    /**
     * The revision of this auto scaling configuration.
     */
    public val autoScalingConfigurationRevision: Output<Int>
        get() = javaResource.autoScalingConfigurationRevision().applyValue({ args0 -> args0 })

    public val hasAssociatedService: Output<Boolean>
        get() = javaResource.hasAssociatedService().applyValue({ args0 -> args0 })

    public val isDefault: Output<Boolean>
        get() = javaResource.isDefault().applyValue({ args0 -> args0 })

    /**
     * Whether the auto scaling configuration has the highest `auto_scaling_configuration_revision` among all configurations that share the same `auto_scaling_configuration_name`.
     */
    public val latest: Output<Boolean>
        get() = javaResource.latest().applyValue({ args0 -> args0 })

    /**
     * Maximal number of concurrent requests that you want an instance to process. When the number of concurrent requests goes over this limit, App Runner scales up your service.
     */
    public val maxConcurrency: Output<Int>?
        get() = javaResource.maxConcurrency().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Maximal number of instances that App Runner provisions for your service.
     */
    public val maxSize: Output<Int>?
        get() = javaResource.maxSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Minimal number of instances that App Runner provisions for your service.
     */
    public val minSize: Output<Int>?
        get() = javaResource.minSize().applyValue({ args0 -> args0.map({ args0 -> args0 }).orElse(null) })

    /**
     * Current state of the auto scaling configuration. An INACTIVE configuration revision has been deleted and can't be used. It is permanently removed some time after deletion.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object AutoScalingConfigurationVersionMapper :
    ResourceMapper<AutoScalingConfigurationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.AutoScalingConfigurationVersion::class == javaResource::class

    override fun map(javaResource: Resource): AutoScalingConfigurationVersion =
        AutoScalingConfigurationVersion(
            javaResource as
                com.pulumi.aws.apprunner.AutoScalingConfigurationVersion,
        )
}

/**
 * @see [AutoScalingConfigurationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [AutoScalingConfigurationVersion].
 */
public suspend fun autoScalingConfigurationVersion(
    name: String,
    block: suspend AutoScalingConfigurationVersionResourceBuilder.() -> Unit,
): AutoScalingConfigurationVersion {
    val builder = AutoScalingConfigurationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [AutoScalingConfigurationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun autoScalingConfigurationVersion(name: String): AutoScalingConfigurationVersion {
    val builder = AutoScalingConfigurationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
