@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.ConnectionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an App Runner Connection.
 * > **NOTE:** After creation, you must complete the authentication handshake using the App Runner console.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Connection("example", {
 *     connectionName: "example",
 *     providerType: "GITHUB",
 *     tags: {
 *         Name: "example-apprunner-connection",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Connection("example",
 *     connection_name="example",
 *     provider_type="GITHUB",
 *     tags={
 *         "Name": "example-apprunner-connection",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Connection("example", new()
 *     {
 *         ConnectionName = "example",
 *         ProviderType = "GITHUB",
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-connection" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewConnection(ctx, "example", &apprunner.ConnectionArgs{
 * 			ConnectionName: pulumi.String("example"),
 * 			ProviderType:   pulumi.String("GITHUB"),
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-connection"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Connection;
 * import com.pulumi.aws.apprunner.ConnectionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Connection("example", ConnectionArgs.builder()
 *             .connectionName("example")
 *             .providerType("GITHUB")
 *             .tags(Map.of("Name", "example-apprunner-connection"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Connection
 *     properties:
 *       connectionName: example
 *       providerType: GITHUB
 *       tags:
 *         Name: example-apprunner-connection
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner Connections using the `connection_name`. For example:
 * ```sh
 * $ pulumi import aws:apprunner/connection:Connection example example
 * ```
 * @property connectionName Name of the connection.
 * @property providerType Source repository provider. Valid values: `GITHUB`.
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ConnectionArgs(
    public val connectionName: Output<String>? = null,
    public val providerType: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.ConnectionArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.ConnectionArgs =
        com.pulumi.aws.apprunner.ConnectionArgs.builder()
            .connectionName(connectionName?.applyValue({ args0 -> args0 }))
            .providerType(providerType?.applyValue({ args0 -> args0 }))
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ConnectionArgs].
 */
@PulumiTagMarker
public class ConnectionArgsBuilder internal constructor() {
    private var connectionName: Output<String>? = null

    private var providerType: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value Name of the connection.
     */
    @JvmName("awepmdnmgvpxljfh")
    public suspend fun connectionName(`value`: Output<String>) {
        this.connectionName = value
    }

    /**
     * @param value Source repository provider. Valid values: `GITHUB`.
     */
    @JvmName("migtcwcnomxcuuoh")
    public suspend fun providerType(`value`: Output<String>) {
        this.providerType = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("dgtidqjaoyfxexwf")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Name of the connection.
     */
    @JvmName("ljcxiprnekxirady")
    public suspend fun connectionName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionName = mapped
    }

    /**
     * @param value Source repository provider. Valid values: `GITHUB`.
     */
    @JvmName("gdpudclevmxxtupk")
    public suspend fun providerType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.providerType = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("haplmmubegtdnyhq")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("jrbjcdmegqmxtxon")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ConnectionArgs = ConnectionArgs(
        connectionName = connectionName,
        providerType = providerType,
        tags = tags,
    )
}
