@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.kotlin.outputs.CustomDomainAssociationCertificateValidationRecord
import com.pulumi.aws.apprunner.kotlin.outputs.CustomDomainAssociationCertificateValidationRecord.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [CustomDomainAssociation].
 */
@PulumiTagMarker
public class CustomDomainAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: CustomDomainAssociationArgs = CustomDomainAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend CustomDomainAssociationArgsBuilder.() -> Unit) {
        val builder = CustomDomainAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): CustomDomainAssociation {
        val builtJavaResource =
            com.pulumi.aws.apprunner.CustomDomainAssociation(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return CustomDomainAssociation(builtJavaResource)
    }
}

/**
 * Manages an App Runner Custom Domain association.
 * > **NOTE:** After creation, you must use the information in the `certification_validation_records` attribute to add CNAME records to your Domain Name System (DNS). For each mapped domain name, add a mapping to the target App Runner subdomain (found in the `dns_target` attribute) and one or more certificate validation records. App Runner then performs DNS validation to verify that you own or control the domain name you associated. App Runner tracks domain validity in a certificate stored in AWS Certificate Manager (ACM).
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.CustomDomainAssociation("example", {
 *     domainName: "example.com",
 *     serviceArn: exampleAwsApprunnerService.arn,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.CustomDomainAssociation("example",
 *     domain_name="example.com",
 *     service_arn=example_aws_apprunner_service["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.CustomDomainAssociation("example", new()
 *     {
 *         DomainName = "example.com",
 *         ServiceArn = exampleAwsApprunnerService.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewCustomDomainAssociation(ctx, "example", &apprunner.CustomDomainAssociationArgs{
 * 			DomainName: pulumi.String("example.com"),
 * 			ServiceArn: pulumi.Any(exampleAwsApprunnerService.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.CustomDomainAssociation;
 * import com.pulumi.aws.apprunner.CustomDomainAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new CustomDomainAssociation("example", CustomDomainAssociationArgs.builder()
 *             .domainName("example.com")
 *             .serviceArn(exampleAwsApprunnerService.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:CustomDomainAssociation
 *     properties:
 *       domainName: example.com
 *       serviceArn: ${exampleAwsApprunnerService.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner Custom Domain Associations using the `domain_name` and `service_arn` separated by a comma (`,`). For example:
 * ```sh
 * $ pulumi import aws:apprunner/customDomainAssociation:CustomDomainAssociation example example.com,arn:aws:apprunner:us-east-1:123456789012:service/example-app/8fe1e10304f84fd2b0df550fe98a71fa
 * ```
 */
public class CustomDomainAssociation internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.CustomDomainAssociation,
) : KotlinCustomResource(javaResource, CustomDomainAssociationMapper) {
    /**
     * A set of certificate CNAME records used for this domain name. See Certificate Validation Records below for more details.
     */
    public val certificateValidationRecords:
        Output<List<CustomDomainAssociationCertificateValidationRecord>>
        get() = javaResource.certificateValidationRecords().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> toKotlin(args0) })
            })
        })

    /**
     * App Runner subdomain of the App Runner service. The custom domain name is mapped to this target name. Attribute only available if resource created (not imported) with this provider.
     */
    public val dnsTarget: Output<String>
        get() = javaResource.dnsTarget().applyValue({ args0 -> args0 })

    /**
     * Custom domain endpoint to association. Specify a base domain e.g., `example.com` or a subdomain e.g., `subdomain.example.com`.
     */
    public val domainName: Output<String>
        get() = javaResource.domainName().applyValue({ args0 -> args0 })

    /**
     * Whether to associate the subdomain with the App Runner service in addition to the base domain. Defaults to `true`.
     */
    public val enableWwwSubdomain: Output<Boolean>?
        get() = javaResource.enableWwwSubdomain().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * ARN of the App Runner service.
     */
    public val serviceArn: Output<String>
        get() = javaResource.serviceArn().applyValue({ args0 -> args0 })

    /**
     * Current state of the certificate CNAME record validation. It should change to `SUCCESS` after App Runner completes validation with your DNS.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })
}

public object CustomDomainAssociationMapper : ResourceMapper<CustomDomainAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.CustomDomainAssociation::class == javaResource::class

    override fun map(javaResource: Resource): CustomDomainAssociation =
        CustomDomainAssociation(javaResource as com.pulumi.aws.apprunner.CustomDomainAssociation)
}

/**
 * @see [CustomDomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [CustomDomainAssociation].
 */
public suspend fun customDomainAssociation(
    name: String,
    block: suspend CustomDomainAssociationResourceBuilder.() -> Unit,
): CustomDomainAssociation {
    val builder = CustomDomainAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [CustomDomainAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun customDomainAssociation(name: String): CustomDomainAssociation {
    val builder = CustomDomainAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
