@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [DefaultAutoScalingConfigurationVersion].
 */
@PulumiTagMarker
public class DefaultAutoScalingConfigurationVersionResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DefaultAutoScalingConfigurationVersionArgs =
        DefaultAutoScalingConfigurationVersionArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DefaultAutoScalingConfigurationVersionArgsBuilder.() -> Unit) {
        val builder = DefaultAutoScalingConfigurationVersionArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DefaultAutoScalingConfigurationVersion {
        val builtJavaResource =
            com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersion(
                this.name,
                this.args.toJava(),
                this.opts.toJava(),
            )
        return DefaultAutoScalingConfigurationVersion(builtJavaResource)
    }
}

/**
 * Manages the default App Runner auto scaling configuration.
 * When creating or updating this resource the existing default auto scaling configuration will be set to non-default automatically.
 * When creating or updating this resource the configuration is automatically assigned as the default to the new services you create in the future. The new default designation doesn't affect the associations that were previously set for existing services.
 * Each account can have only one default auto scaling configuration per Region.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.AutoScalingConfigurationVersion("example", {
 *     autoScalingConfigurationName: "example",
 *     maxConcurrency: 50,
 *     maxSize: 10,
 *     minSize: 2,
 * });
 * const exampleDefaultAutoScalingConfigurationVersion = new aws.apprunner.DefaultAutoScalingConfigurationVersion("example", {autoScalingConfigurationArn: example.arn});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.AutoScalingConfigurationVersion("example",
 *     auto_scaling_configuration_name="example",
 *     max_concurrency=50,
 *     max_size=10,
 *     min_size=2)
 * example_default_auto_scaling_configuration_version = aws.apprunner.DefaultAutoScalingConfigurationVersion("example", auto_scaling_configuration_arn=example.arn)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.AutoScalingConfigurationVersion("example", new()
 *     {
 *         AutoScalingConfigurationName = "example",
 *         MaxConcurrency = 50,
 *         MaxSize = 10,
 *         MinSize = 2,
 *     });
 *     var exampleDefaultAutoScalingConfigurationVersion = new Aws.AppRunner.DefaultAutoScalingConfigurationVersion("example", new()
 *     {
 *         AutoScalingConfigurationArn = example.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		example, err := apprunner.NewAutoScalingConfigurationVersion(ctx, "example", &apprunner.AutoScalingConfigurationVersionArgs{
 * 			AutoScalingConfigurationName: pulumi.String("example"),
 * 			MaxConcurrency:               pulumi.Int(50),
 * 			MaxSize:                      pulumi.Int(10),
 * 			MinSize:                      pulumi.Int(2),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apprunner.NewDefaultAutoScalingConfigurationVersion(ctx, "example", &apprunner.DefaultAutoScalingConfigurationVersionArgs{
 * 			AutoScalingConfigurationArn: example.Arn,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersion;
 * import com.pulumi.aws.apprunner.AutoScalingConfigurationVersionArgs;
 * import com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersion;
 * import com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersionArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new AutoScalingConfigurationVersion("example", AutoScalingConfigurationVersionArgs.builder()
 *             .autoScalingConfigurationName("example")
 *             .maxConcurrency(50)
 *             .maxSize(10)
 *             .minSize(2)
 *             .build());
 *         var exampleDefaultAutoScalingConfigurationVersion = new DefaultAutoScalingConfigurationVersion("exampleDefaultAutoScalingConfigurationVersion", DefaultAutoScalingConfigurationVersionArgs.builder()
 *             .autoScalingConfigurationArn(example.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:AutoScalingConfigurationVersion
 *     properties:
 *       autoScalingConfigurationName: example
 *       maxConcurrency: 50
 *       maxSize: 10
 *       minSize: 2
 *   exampleDefaultAutoScalingConfigurationVersion:
 *     type: aws:apprunner:DefaultAutoScalingConfigurationVersion
 *     name: example
 *     properties:
 *       autoScalingConfigurationArn: ${example.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner default auto scaling configurations using the current Region. For example:
 * ```sh
 * $ pulumi import aws:apprunner/defaultAutoScalingConfigurationVersion:DefaultAutoScalingConfigurationVersion example us-west-2
 * ```
 */
public class DefaultAutoScalingConfigurationVersion internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersion,
) : KotlinCustomResource(javaResource, DefaultAutoScalingConfigurationVersionMapper) {
    /**
     * The ARN of the App Runner auto scaling configuration that you want to set as the default.
     */
    public val autoScalingConfigurationArn: Output<String>
        get() = javaResource.autoScalingConfigurationArn().applyValue({ args0 -> args0 })
}

public object DefaultAutoScalingConfigurationVersionMapper :
    ResourceMapper<DefaultAutoScalingConfigurationVersion> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersion::class == javaResource::class

    override fun map(javaResource: Resource): DefaultAutoScalingConfigurationVersion =
        DefaultAutoScalingConfigurationVersion(
            javaResource as
                com.pulumi.aws.apprunner.DefaultAutoScalingConfigurationVersion,
        )
}

/**
 * @see [DefaultAutoScalingConfigurationVersion].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DefaultAutoScalingConfigurationVersion].
 */
public suspend fun defaultAutoScalingConfigurationVersion(
    name: String,
    block: suspend DefaultAutoScalingConfigurationVersionResourceBuilder.() -> Unit,
): DefaultAutoScalingConfigurationVersion {
    val builder = DefaultAutoScalingConfigurationVersionResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DefaultAutoScalingConfigurationVersion].
 * @param name The _unique_ name of the resulting resource.
 */
public fun defaultAutoScalingConfigurationVersion(name: String): DefaultAutoScalingConfigurationVersion {
    val builder = DefaultAutoScalingConfigurationVersionResourceBuilder()
    builder.name(name)
    return builder.build()
}
