@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.kotlin.outputs.DeploymentTimeouts
import com.pulumi.aws.apprunner.kotlin.outputs.DeploymentTimeouts.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [Deployment].
 */
@PulumiTagMarker
public class DeploymentResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DeploymentArgs = DeploymentArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DeploymentArgsBuilder.() -> Unit) {
        val builder = DeploymentArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Deployment {
        val builtJavaResource = com.pulumi.aws.apprunner.Deployment(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Deployment(builtJavaResource)
    }
}

/**
 * Manages an App Runner Deployment Operation.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Deployment("example", {serviceArn: exampleAwsApprunnerService.arn});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Deployment("example", service_arn=example_aws_apprunner_service["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Deployment("example", new()
 *     {
 *         ServiceArn = exampleAwsApprunnerService.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewDeployment(ctx, "example", &apprunner.DeploymentArgs{
 * 			ServiceArn: pulumi.Any(exampleAwsApprunnerService.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Deployment;
 * import com.pulumi.aws.apprunner.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Deployment("example", DeploymentArgs.builder()
 *             .serviceArn(exampleAwsApprunnerService.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Deployment
 *     properties:
 *       serviceArn: ${exampleAwsApprunnerService.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 */
public class Deployment internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.Deployment,
) : KotlinCustomResource(javaResource, DeploymentMapper) {
    /**
     * The unique ID of the operation associated with deployment.
     */
    public val operationId: Output<String>
        get() = javaResource.operationId().applyValue({ args0 -> args0 })

    /**
     * The Amazon Resource Name (ARN) of the App Runner service to start the deployment for.
     */
    public val serviceArn: Output<String>
        get() = javaResource.serviceArn().applyValue({ args0 -> args0 })

    /**
     * The current status of the App Runner service deployment.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    public val timeouts: Output<DeploymentTimeouts>?
        get() = javaResource.timeouts().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    toKotlin(args0)
                })
            }).orElse(null)
        })
}

public object DeploymentMapper : ResourceMapper<Deployment> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.Deployment::class == javaResource::class

    override fun map(javaResource: Resource): Deployment = Deployment(
        javaResource as
            com.pulumi.aws.apprunner.Deployment,
    )
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Deployment].
 */
public suspend fun deployment(name: String, block: suspend DeploymentResourceBuilder.() -> Unit): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Deployment].
 * @param name The _unique_ name of the resulting resource.
 */
public fun deployment(name: String): Deployment {
    val builder = DeploymentResourceBuilder()
    builder.name(name)
    return builder.build()
}
