@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.DeploymentArgs.builder
import com.pulumi.aws.apprunner.kotlin.inputs.DeploymentTimeoutsArgs
import com.pulumi.aws.apprunner.kotlin.inputs.DeploymentTimeoutsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 * Manages an App Runner Deployment Operation.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Deployment("example", {serviceArn: exampleAwsApprunnerService.arn});
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Deployment("example", service_arn=example_aws_apprunner_service["arn"])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Deployment("example", new()
 *     {
 *         ServiceArn = exampleAwsApprunnerService.Arn,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewDeployment(ctx, "example", &apprunner.DeploymentArgs{
 * 			ServiceArn: pulumi.Any(exampleAwsApprunnerService.Arn),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Deployment;
 * import com.pulumi.aws.apprunner.DeploymentArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Deployment("example", DeploymentArgs.builder()
 *             .serviceArn(exampleAwsApprunnerService.arn())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Deployment
 *     properties:
 *       serviceArn: ${exampleAwsApprunnerService.arn}
 * ```
 * <!--End PulumiCodeChooser -->
 * @property serviceArn The Amazon Resource Name (ARN) of the App Runner service to start the deployment for.
 * @property timeouts
 */
public data class DeploymentArgs(
    public val serviceArn: Output<String>? = null,
    public val timeouts: Output<DeploymentTimeoutsArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.DeploymentArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.DeploymentArgs =
        com.pulumi.aws.apprunner.DeploymentArgs.builder()
            .serviceArn(serviceArn?.applyValue({ args0 -> args0 }))
            .timeouts(timeouts?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [DeploymentArgs].
 */
@PulumiTagMarker
public class DeploymentArgsBuilder internal constructor() {
    private var serviceArn: Output<String>? = null

    private var timeouts: Output<DeploymentTimeoutsArgs>? = null

    /**
     * @param value The Amazon Resource Name (ARN) of the App Runner service to start the deployment for.
     */
    @JvmName("atytxhonnmlcgtoa")
    public suspend fun serviceArn(`value`: Output<String>) {
        this.serviceArn = value
    }

    /**
     * @param value
     */
    @JvmName("coytgpxgwaqpdlkp")
    public suspend fun timeouts(`value`: Output<DeploymentTimeoutsArgs>) {
        this.timeouts = value
    }

    /**
     * @param value The Amazon Resource Name (ARN) of the App Runner service to start the deployment for.
     */
    @JvmName("owfmgvwrysytewib")
    public suspend fun serviceArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceArn = mapped
    }

    /**
     * @param value
     */
    @JvmName("lvrsghaxejojrkbu")
    public suspend fun timeouts(`value`: DeploymentTimeoutsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.timeouts = mapped
    }

    /**
     * @param argument
     */
    @JvmName("gdopoiktglwpbfcw")
    public suspend fun timeouts(argument: suspend DeploymentTimeoutsArgsBuilder.() -> Unit) {
        val toBeMapped = DeploymentTimeoutsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.timeouts = mapped
    }

    internal fun build(): DeploymentArgs = DeploymentArgs(
        serviceArn = serviceArn,
        timeouts = timeouts,
    )
}
