@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.kotlin.outputs.ServiceEncryptionConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceHealthCheckConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceInstanceConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceNetworkConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceObservabilityConfiguration
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfiguration
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceEncryptionConfiguration.Companion.toKotlin as serviceEncryptionConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceHealthCheckConfiguration.Companion.toKotlin as serviceHealthCheckConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceInstanceConfiguration.Companion.toKotlin as serviceInstanceConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceNetworkConfiguration.Companion.toKotlin as serviceNetworkConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceObservabilityConfiguration.Companion.toKotlin as serviceObservabilityConfigurationToKotlin
import com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfiguration.Companion.toKotlin as serviceSourceConfigurationToKotlin

/**
 * Builder for [Service].
 */
@PulumiTagMarker
public class ServiceResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ServiceArgs = ServiceArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ServiceArgsBuilder.() -> Unit) {
        val builder = ServiceArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Service {
        val builtJavaResource = com.pulumi.aws.apprunner.Service(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Service(builtJavaResource)
    }
}

/**
 * Manages an App Runner Service.
 * ## Example Usage
 * ### Service with a Code Repository Source
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Service("example", {
 *     serviceName: "example",
 *     sourceConfiguration: {
 *         authenticationConfiguration: {
 *             connectionArn: exampleAwsApprunnerConnection.arn,
 *         },
 *         codeRepository: {
 *             codeConfiguration: {
 *                 codeConfigurationValues: {
 *                     buildCommand: "python setup.py develop",
 *                     port: "8000",
 *                     runtime: "PYTHON_3",
 *                     startCommand: "python runapp.py",
 *                 },
 *                 configurationSource: "API",
 *             },
 *             repositoryUrl: "https://github.com/example/my-example-python-app",
 *             sourceCodeVersion: {
 *                 type: "BRANCH",
 *                 value: "main",
 *             },
 *         },
 *     },
 *     networkConfiguration: {
 *         egressConfiguration: {
 *             egressType: "VPC",
 *             vpcConnectorArn: connector.arn,
 *         },
 *     },
 *     tags: {
 *         Name: "example-apprunner-service",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Service("example",
 *     service_name="example",
 *     source_configuration={
 *         "authentication_configuration": {
 *             "connection_arn": example_aws_apprunner_connection["arn"],
 *         },
 *         "code_repository": {
 *             "code_configuration": {
 *                 "code_configuration_values": {
 *                     "build_command": "python setup.py develop",
 *                     "port": "8000",
 *                     "runtime": "PYTHON_3",
 *                     "start_command": "python runapp.py",
 *                 },
 *                 "configuration_source": "API",
 *             },
 *             "repository_url": "https://github.com/example/my-example-python-app",
 *             "source_code_version": {
 *                 "type": "BRANCH",
 *                 "value": "main",
 *             },
 *         },
 *     },
 *     network_configuration={
 *         "egress_configuration": {
 *             "egress_type": "VPC",
 *             "vpc_connector_arn": connector["arn"],
 *         },
 *     },
 *     tags={
 *         "Name": "example-apprunner-service",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Service("example", new()
 *     {
 *         ServiceName = "example",
 *         SourceConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationArgs
 *         {
 *             AuthenticationConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs
 *             {
 *                 ConnectionArn = exampleAwsApprunnerConnection.Arn,
 *             },
 *             CodeRepository = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositoryArgs
 *             {
 *                 CodeConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs
 *                 {
 *                     CodeConfigurationValues = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs
 *                     {
 *                         BuildCommand = "python setup.py develop",
 *                         Port = "8000",
 *                         Runtime = "PYTHON_3",
 *                         StartCommand = "python runapp.py",
 *                     },
 *                     ConfigurationSource = "API",
 *                 },
 *                 RepositoryUrl = "https://github.com/example/my-example-python-app",
 *                 SourceCodeVersion = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs
 *                 {
 *                     Type = "BRANCH",
 *                     Value = "main",
 *                 },
 *             },
 *         },
 *         NetworkConfiguration = new Aws.AppRunner.Inputs.ServiceNetworkConfigurationArgs
 *         {
 *             EgressConfiguration = new Aws.AppRunner.Inputs.ServiceNetworkConfigurationEgressConfigurationArgs
 *             {
 *                 EgressType = "VPC",
 *                 VpcConnectorArn = connector.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-service" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewService(ctx, "example", &apprunner.ServiceArgs{
 * 			ServiceName: pulumi.String("example"),
 * 			SourceConfiguration: &apprunner.ServiceSourceConfigurationArgs{
 * 				AuthenticationConfiguration: &apprunner.ServiceSourceConfigurationAuthenticationConfigurationArgs{
 * 					ConnectionArn: pulumi.Any(exampleAwsApprunnerConnection.Arn),
 * 				},
 * 				CodeRepository: &apprunner.ServiceSourceConfigurationCodeRepositoryArgs{
 * 					CodeConfiguration: &apprunner.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs{
 * 						CodeConfigurationValues: &apprunner.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs{
 * 							BuildCommand: pulumi.String("python setup.py develop"),
 * 							Port:         pulumi.String("8000"),
 * 							Runtime:      pulumi.String("PYTHON_3"),
 * 							StartCommand: pulumi.String("python runapp.py"),
 * 						},
 * 						ConfigurationSource: pulumi.String("API"),
 * 					},
 * 					RepositoryUrl: pulumi.String("https://github.com/example/my-example-python-app"),
 * 					SourceCodeVersion: &apprunner.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs{
 * 						Type:  pulumi.String("BRANCH"),
 * 						Value: pulumi.String("main"),
 * 					},
 * 				},
 * 			},
 * 			NetworkConfiguration: &apprunner.ServiceNetworkConfigurationArgs{
 * 				EgressConfiguration: &apprunner.ServiceNetworkConfigurationEgressConfigurationArgs{
 * 					EgressType:      pulumi.String("VPC"),
 * 					VpcConnectorArn: pulumi.Any(connector.Arn),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-service"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .authenticationConfiguration(ServiceSourceConfigurationAuthenticationConfigurationArgs.builder()
 *                     .connectionArn(exampleAwsApprunnerConnection.arn())
 *                     .build())
 *                 .codeRepository(ServiceSourceConfigurationCodeRepositoryArgs.builder()
 *                     .codeConfiguration(ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs.builder()
 *                         .codeConfigurationValues(ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs.builder()
 *                             .buildCommand("python setup.py develop")
 *                             .port("8000")
 *                             .runtime("PYTHON_3")
 *                             .startCommand("python runapp.py")
 *                             .build())
 *                         .configurationSource("API")
 *                         .build())
 *                     .repositoryUrl("https://github.com/example/my-example-python-app")
 *                     .sourceCodeVersion(ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs.builder()
 *                         .type("BRANCH")
 *                         .value("main")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .networkConfiguration(ServiceNetworkConfigurationArgs.builder()
 *                 .egressConfiguration(ServiceNetworkConfigurationEgressConfigurationArgs.builder()
 *                     .egressType("VPC")
 *                     .vpcConnectorArn(connector.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Service
 *     properties:
 *       serviceName: example
 *       sourceConfiguration:
 *         authenticationConfiguration:
 *           connectionArn: ${exampleAwsApprunnerConnection.arn}
 *         codeRepository:
 *           codeConfiguration:
 *             codeConfigurationValues:
 *               buildCommand: python setup.py develop
 *               port: '8000'
 *               runtime: PYTHON_3
 *               startCommand: python runapp.py
 *             configurationSource: API
 *           repositoryUrl: https://github.com/example/my-example-python-app
 *           sourceCodeVersion:
 *             type: BRANCH
 *             value: main
 *       networkConfiguration:
 *         egressConfiguration:
 *           egressType: VPC
 *           vpcConnectorArn: ${connector.arn}
 *       tags:
 *         Name: example-apprunner-service
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Service with an Image Repository Source
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Service("example", {
 *     serviceName: "example",
 *     sourceConfiguration: {
 *         imageRepository: {
 *             imageConfiguration: {
 *                 port: "8000",
 *             },
 *             imageIdentifier: "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             imageRepositoryType: "ECR_PUBLIC",
 *         },
 *         autoDeploymentsEnabled: false,
 *     },
 *     tags: {
 *         Name: "example-apprunner-service",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Service("example",
 *     service_name="example",
 *     source_configuration={
 *         "image_repository": {
 *             "image_configuration": {
 *                 "port": "8000",
 *             },
 *             "image_identifier": "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             "image_repository_type": "ECR_PUBLIC",
 *         },
 *         "auto_deployments_enabled": False,
 *     },
 *     tags={
 *         "Name": "example-apprunner-service",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Service("example", new()
 *     {
 *         ServiceName = "example",
 *         SourceConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationArgs
 *         {
 *             ImageRepository = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryArgs
 *             {
 *                 ImageConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs
 *                 {
 *                     Port = "8000",
 *                 },
 *                 ImageIdentifier = "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *                 ImageRepositoryType = "ECR_PUBLIC",
 *             },
 *             AutoDeploymentsEnabled = false,
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-service" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewService(ctx, "example", &apprunner.ServiceArgs{
 * 			ServiceName: pulumi.String("example"),
 * 			SourceConfiguration: &apprunner.ServiceSourceConfigurationArgs{
 * 				ImageRepository: &apprunner.ServiceSourceConfigurationImageRepositoryArgs{
 * 					ImageConfiguration: &apprunner.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs{
 * 						Port: pulumi.String("8000"),
 * 					},
 * 					ImageIdentifier:     pulumi.String("public.ecr.aws/aws-containers/hello-app-runner:latest"),
 * 					ImageRepositoryType: pulumi.String("ECR_PUBLIC"),
 * 				},
 * 				AutoDeploymentsEnabled: pulumi.Bool(false),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-service"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port("8000")
 *                         .build())
 *                     .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                     .imageRepositoryType("ECR_PUBLIC")
 *                     .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Service
 *     properties:
 *       serviceName: example
 *       sourceConfiguration:
 *         imageRepository:
 *           imageConfiguration:
 *             port: '8000'
 *           imageIdentifier: public.ecr.aws/aws-containers/hello-app-runner:latest
 *           imageRepositoryType: ECR_PUBLIC
 *         autoDeploymentsEnabled: false
 *       tags:
 *         Name: example-apprunner-service
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Service with Observability Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleObservabilityConfiguration = new aws.apprunner.ObservabilityConfiguration("example", {
 *     observabilityConfigurationName: "example",
 *     traceConfiguration: {
 *         vendor: "AWSXRAY",
 *     },
 * });
 * const example = new aws.apprunner.Service("example", {
 *     serviceName: "example",
 *     observabilityConfiguration: {
 *         observabilityConfigurationArn: exampleObservabilityConfiguration.arn,
 *         observabilityEnabled: true,
 *     },
 *     sourceConfiguration: {
 *         imageRepository: {
 *             imageConfiguration: {
 *                 port: "8000",
 *             },
 *             imageIdentifier: "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             imageRepositoryType: "ECR_PUBLIC",
 *         },
 *         autoDeploymentsEnabled: false,
 *     },
 *     tags: {
 *         Name: "example-apprunner-service",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_observability_configuration = aws.apprunner.ObservabilityConfiguration("example",
 *     observability_configuration_name="example",
 *     trace_configuration={
 *         "vendor": "AWSXRAY",
 *     })
 * example = aws.apprunner.Service("example",
 *     service_name="example",
 *     observability_configuration={
 *         "observability_configuration_arn": example_observability_configuration.arn,
 *         "observability_enabled": True,
 *     },
 *     source_configuration={
 *         "image_repository": {
 *             "image_configuration": {
 *                 "port": "8000",
 *             },
 *             "image_identifier": "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             "image_repository_type": "ECR_PUBLIC",
 *         },
 *         "auto_deployments_enabled": False,
 *     },
 *     tags={
 *         "Name": "example-apprunner-service",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleObservabilityConfiguration = new Aws.AppRunner.ObservabilityConfiguration("example", new()
 *     {
 *         ObservabilityConfigurationName = "example",
 *         TraceConfiguration = new Aws.AppRunner.Inputs.ObservabilityConfigurationTraceConfigurationArgs
 *         {
 *             Vendor = "AWSXRAY",
 *         },
 *     });
 *     var example = new Aws.AppRunner.Service("example", new()
 *     {
 *         ServiceName = "example",
 *         ObservabilityConfiguration = new Aws.AppRunner.Inputs.ServiceObservabilityConfigurationArgs
 *         {
 *             ObservabilityConfigurationArn = exampleObservabilityConfiguration.Arn,
 *             ObservabilityEnabled = true,
 *         },
 *         SourceConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationArgs
 *         {
 *             ImageRepository = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryArgs
 *             {
 *                 ImageConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs
 *                 {
 *                     Port = "8000",
 *                 },
 *                 ImageIdentifier = "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *                 ImageRepositoryType = "ECR_PUBLIC",
 *             },
 *             AutoDeploymentsEnabled = false,
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-service" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleObservabilityConfiguration, err := apprunner.NewObservabilityConfiguration(ctx, "example", &apprunner.ObservabilityConfigurationArgs{
 * 			ObservabilityConfigurationName: pulumi.String("example"),
 * 			TraceConfiguration: &apprunner.ObservabilityConfigurationTraceConfigurationArgs{
 * 				Vendor: pulumi.String("AWSXRAY"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apprunner.NewService(ctx, "example", &apprunner.ServiceArgs{
 * 			ServiceName: pulumi.String("example"),
 * 			ObservabilityConfiguration: &apprunner.ServiceObservabilityConfigurationArgs{
 * 				ObservabilityConfigurationArn: exampleObservabilityConfiguration.Arn,
 * 				ObservabilityEnabled:          pulumi.Bool(true),
 * 			},
 * 			SourceConfiguration: &apprunner.ServiceSourceConfigurationArgs{
 * 				ImageRepository: &apprunner.ServiceSourceConfigurationImageRepositoryArgs{
 * 					ImageConfiguration: &apprunner.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs{
 * 						Port: pulumi.String("8000"),
 * 					},
 * 					ImageIdentifier:     pulumi.String("public.ecr.aws/aws-containers/hello-app-runner:latest"),
 * 					ImageRepositoryType: pulumi.String("ECR_PUBLIC"),
 * 				},
 * 				AutoDeploymentsEnabled: pulumi.Bool(false),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-service"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.ObservabilityConfiguration;
 * import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleObservabilityConfiguration = new ObservabilityConfiguration("exampleObservabilityConfiguration", ObservabilityConfigurationArgs.builder()
 *             .observabilityConfigurationName("example")
 *             .traceConfiguration(ObservabilityConfigurationTraceConfigurationArgs.builder()
 *                 .vendor("AWSXRAY")
 *                 .build())
 *             .build());
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .observabilityConfiguration(ServiceObservabilityConfigurationArgs.builder()
 *                 .observabilityConfigurationArn(exampleObservabilityConfiguration.arn())
 *                 .observabilityEnabled(true)
 *                 .build())
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port("8000")
 *                         .build())
 *                     .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                     .imageRepositoryType("ECR_PUBLIC")
 *                     .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Service
 *     properties:
 *       serviceName: example
 *       observabilityConfiguration:
 *         observabilityConfigurationArn: ${exampleObservabilityConfiguration.arn}
 *         observabilityEnabled: true
 *       sourceConfiguration:
 *         imageRepository:
 *           imageConfiguration:
 *             port: '8000'
 *           imageIdentifier: public.ecr.aws/aws-containers/hello-app-runner:latest
 *           imageRepositoryType: ECR_PUBLIC
 *         autoDeploymentsEnabled: false
 *       tags:
 *         Name: example-apprunner-service
 *   exampleObservabilityConfiguration:
 *     type: aws:apprunner:ObservabilityConfiguration
 *     name: example
 *     properties:
 *       observabilityConfigurationName: example
 *       traceConfiguration:
 *         vendor: AWSXRAY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner Services using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:apprunner/service:Service example arn:aws:apprunner:us-east-1:1234567890:service/example/0a03292a89764e5882c41d8f991c82fe
 * ```
 */
public class Service internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.Service,
) : KotlinCustomResource(javaResource, ServiceMapper) {
    /**
     * ARN of the App Runner service.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     */
    public val autoScalingConfigurationArn: Output<String>
        get() = javaResource.autoScalingConfigurationArn().applyValue({ args0 -> args0 })

    /**
     * An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     */
    public val encryptionConfiguration: Output<ServiceEncryptionConfiguration>?
        get() = javaResource.encryptionConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceEncryptionConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     */
    public val healthCheckConfiguration: Output<ServiceHealthCheckConfiguration>
        get() = javaResource.healthCheckConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceHealthCheckConfigurationToKotlin(args0)
            })
        })

    /**
     * The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     */
    public val instanceConfiguration: Output<ServiceInstanceConfiguration>
        get() = javaResource.instanceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceInstanceConfigurationToKotlin(args0)
            })
        })

    /**
     * Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     */
    public val networkConfiguration: Output<ServiceNetworkConfiguration>
        get() = javaResource.networkConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceNetworkConfigurationToKotlin(args0)
            })
        })

    /**
     * The observability configuration of your service. See Observability Configuration below for more details.
     */
    public val observabilityConfiguration: Output<ServiceObservabilityConfiguration>?
        get() = javaResource.observabilityConfiguration().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> serviceObservabilityConfigurationToKotlin(args0) })
            }).orElse(null)
        })

    /**
     * An alphanumeric ID that App Runner generated for this service. Unique within the AWS Region.
     */
    public val serviceId: Output<String>
        get() = javaResource.serviceId().applyValue({ args0 -> args0 })

    /**
     * Name of the service.
     */
    public val serviceName: Output<String>
        get() = javaResource.serviceName().applyValue({ args0 -> args0 })

    /**
     * Subdomain URL that App Runner generated for this service. You can use this URL to access your service web application.
     */
    public val serviceUrl: Output<String>
        get() = javaResource.serviceUrl().applyValue({ args0 -> args0 })

    /**
     * The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * The following arguments are optional:
     */
    public val sourceConfiguration: Output<ServiceSourceConfiguration>
        get() = javaResource.sourceConfiguration().applyValue({ args0 ->
            args0.let({ args0 ->
                serviceSourceConfigurationToKotlin(args0)
            })
        })

    /**
     * Current state of the App Runner service.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })
}

public object ServiceMapper : ResourceMapper<Service> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.Service::class == javaResource::class

    override fun map(javaResource: Resource): Service = Service(
        javaResource as
            com.pulumi.aws.apprunner.Service,
    )
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Service].
 */
public suspend fun service(name: String, block: suspend ServiceResourceBuilder.() -> Unit): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Service].
 * @param name The _unique_ name of the resulting resource.
 */
public fun service(name: String): Service {
    val builder = ServiceResourceBuilder()
    builder.name(name)
    return builder.build()
}
