@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.aws.apprunner.ServiceArgs.builder
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceEncryptionConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceEncryptionConfigurationArgsBuilder
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceHealthCheckConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceHealthCheckConfigurationArgsBuilder
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceInstanceConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceInstanceConfigurationArgsBuilder
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceNetworkConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceNetworkConfigurationArgsBuilder
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceObservabilityConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceObservabilityConfigurationArgsBuilder
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceSourceConfigurationArgs
import com.pulumi.aws.apprunner.kotlin.inputs.ServiceSourceConfigurationArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Manages an App Runner Service.
 * ## Example Usage
 * ### Service with a Code Repository Source
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Service("example", {
 *     serviceName: "example",
 *     sourceConfiguration: {
 *         authenticationConfiguration: {
 *             connectionArn: exampleAwsApprunnerConnection.arn,
 *         },
 *         codeRepository: {
 *             codeConfiguration: {
 *                 codeConfigurationValues: {
 *                     buildCommand: "python setup.py develop",
 *                     port: "8000",
 *                     runtime: "PYTHON_3",
 *                     startCommand: "python runapp.py",
 *                 },
 *                 configurationSource: "API",
 *             },
 *             repositoryUrl: "https://github.com/example/my-example-python-app",
 *             sourceCodeVersion: {
 *                 type: "BRANCH",
 *                 value: "main",
 *             },
 *         },
 *     },
 *     networkConfiguration: {
 *         egressConfiguration: {
 *             egressType: "VPC",
 *             vpcConnectorArn: connector.arn,
 *         },
 *     },
 *     tags: {
 *         Name: "example-apprunner-service",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Service("example",
 *     service_name="example",
 *     source_configuration={
 *         "authentication_configuration": {
 *             "connection_arn": example_aws_apprunner_connection["arn"],
 *         },
 *         "code_repository": {
 *             "code_configuration": {
 *                 "code_configuration_values": {
 *                     "build_command": "python setup.py develop",
 *                     "port": "8000",
 *                     "runtime": "PYTHON_3",
 *                     "start_command": "python runapp.py",
 *                 },
 *                 "configuration_source": "API",
 *             },
 *             "repository_url": "https://github.com/example/my-example-python-app",
 *             "source_code_version": {
 *                 "type": "BRANCH",
 *                 "value": "main",
 *             },
 *         },
 *     },
 *     network_configuration={
 *         "egress_configuration": {
 *             "egress_type": "VPC",
 *             "vpc_connector_arn": connector["arn"],
 *         },
 *     },
 *     tags={
 *         "Name": "example-apprunner-service",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Service("example", new()
 *     {
 *         ServiceName = "example",
 *         SourceConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationArgs
 *         {
 *             AuthenticationConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs
 *             {
 *                 ConnectionArn = exampleAwsApprunnerConnection.Arn,
 *             },
 *             CodeRepository = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositoryArgs
 *             {
 *                 CodeConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs
 *                 {
 *                     CodeConfigurationValues = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs
 *                     {
 *                         BuildCommand = "python setup.py develop",
 *                         Port = "8000",
 *                         Runtime = "PYTHON_3",
 *                         StartCommand = "python runapp.py",
 *                     },
 *                     ConfigurationSource = "API",
 *                 },
 *                 RepositoryUrl = "https://github.com/example/my-example-python-app",
 *                 SourceCodeVersion = new Aws.AppRunner.Inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs
 *                 {
 *                     Type = "BRANCH",
 *                     Value = "main",
 *                 },
 *             },
 *         },
 *         NetworkConfiguration = new Aws.AppRunner.Inputs.ServiceNetworkConfigurationArgs
 *         {
 *             EgressConfiguration = new Aws.AppRunner.Inputs.ServiceNetworkConfigurationEgressConfigurationArgs
 *             {
 *                 EgressType = "VPC",
 *                 VpcConnectorArn = connector.Arn,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-service" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewService(ctx, "example", &apprunner.ServiceArgs{
 * 			ServiceName: pulumi.String("example"),
 * 			SourceConfiguration: &apprunner.ServiceSourceConfigurationArgs{
 * 				AuthenticationConfiguration: &apprunner.ServiceSourceConfigurationAuthenticationConfigurationArgs{
 * 					ConnectionArn: pulumi.Any(exampleAwsApprunnerConnection.Arn),
 * 				},
 * 				CodeRepository: &apprunner.ServiceSourceConfigurationCodeRepositoryArgs{
 * 					CodeConfiguration: &apprunner.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs{
 * 						CodeConfigurationValues: &apprunner.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs{
 * 							BuildCommand: pulumi.String("python setup.py develop"),
 * 							Port:         pulumi.String("8000"),
 * 							Runtime:      pulumi.String("PYTHON_3"),
 * 							StartCommand: pulumi.String("python runapp.py"),
 * 						},
 * 						ConfigurationSource: pulumi.String("API"),
 * 					},
 * 					RepositoryUrl: pulumi.String("https://github.com/example/my-example-python-app"),
 * 					SourceCodeVersion: &apprunner.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs{
 * 						Type:  pulumi.String("BRANCH"),
 * 						Value: pulumi.String("main"),
 * 					},
 * 				},
 * 			},
 * 			NetworkConfiguration: &apprunner.ServiceNetworkConfigurationArgs{
 * 				EgressConfiguration: &apprunner.ServiceNetworkConfigurationEgressConfigurationArgs{
 * 					EgressType:      pulumi.String("VPC"),
 * 					VpcConnectorArn: pulumi.Any(connector.Arn),
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-service"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceNetworkConfigurationEgressConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .authenticationConfiguration(ServiceSourceConfigurationAuthenticationConfigurationArgs.builder()
 *                     .connectionArn(exampleAwsApprunnerConnection.arn())
 *                     .build())
 *                 .codeRepository(ServiceSourceConfigurationCodeRepositoryArgs.builder()
 *                     .codeConfiguration(ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs.builder()
 *                         .codeConfigurationValues(ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs.builder()
 *                             .buildCommand("python setup.py develop")
 *                             .port("8000")
 *                             .runtime("PYTHON_3")
 *                             .startCommand("python runapp.py")
 *                             .build())
 *                         .configurationSource("API")
 *                         .build())
 *                     .repositoryUrl("https://github.com/example/my-example-python-app")
 *                     .sourceCodeVersion(ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs.builder()
 *                         .type("BRANCH")
 *                         .value("main")
 *                         .build())
 *                     .build())
 *                 .build())
 *             .networkConfiguration(ServiceNetworkConfigurationArgs.builder()
 *                 .egressConfiguration(ServiceNetworkConfigurationEgressConfigurationArgs.builder()
 *                     .egressType("VPC")
 *                     .vpcConnectorArn(connector.arn())
 *                     .build())
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Service
 *     properties:
 *       serviceName: example
 *       sourceConfiguration:
 *         authenticationConfiguration:
 *           connectionArn: ${exampleAwsApprunnerConnection.arn}
 *         codeRepository:
 *           codeConfiguration:
 *             codeConfigurationValues:
 *               buildCommand: python setup.py develop
 *               port: '8000'
 *               runtime: PYTHON_3
 *               startCommand: python runapp.py
 *             configurationSource: API
 *           repositoryUrl: https://github.com/example/my-example-python-app
 *           sourceCodeVersion:
 *             type: BRANCH
 *             value: main
 *       networkConfiguration:
 *         egressConfiguration:
 *           egressType: VPC
 *           vpcConnectorArn: ${connector.arn}
 *       tags:
 *         Name: example-apprunner-service
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Service with an Image Repository Source
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.apprunner.Service("example", {
 *     serviceName: "example",
 *     sourceConfiguration: {
 *         imageRepository: {
 *             imageConfiguration: {
 *                 port: "8000",
 *             },
 *             imageIdentifier: "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             imageRepositoryType: "ECR_PUBLIC",
 *         },
 *         autoDeploymentsEnabled: false,
 *     },
 *     tags: {
 *         Name: "example-apprunner-service",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.apprunner.Service("example",
 *     service_name="example",
 *     source_configuration={
 *         "image_repository": {
 *             "image_configuration": {
 *                 "port": "8000",
 *             },
 *             "image_identifier": "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             "image_repository_type": "ECR_PUBLIC",
 *         },
 *         "auto_deployments_enabled": False,
 *     },
 *     tags={
 *         "Name": "example-apprunner-service",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppRunner.Service("example", new()
 *     {
 *         ServiceName = "example",
 *         SourceConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationArgs
 *         {
 *             ImageRepository = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryArgs
 *             {
 *                 ImageConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs
 *                 {
 *                     Port = "8000",
 *                 },
 *                 ImageIdentifier = "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *                 ImageRepositoryType = "ECR_PUBLIC",
 *             },
 *             AutoDeploymentsEnabled = false,
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-service" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewService(ctx, "example", &apprunner.ServiceArgs{
 * 			ServiceName: pulumi.String("example"),
 * 			SourceConfiguration: &apprunner.ServiceSourceConfigurationArgs{
 * 				ImageRepository: &apprunner.ServiceSourceConfigurationImageRepositoryArgs{
 * 					ImageConfiguration: &apprunner.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs{
 * 						Port: pulumi.String("8000"),
 * 					},
 * 					ImageIdentifier:     pulumi.String("public.ecr.aws/aws-containers/hello-app-runner:latest"),
 * 					ImageRepositoryType: pulumi.String("ECR_PUBLIC"),
 * 				},
 * 				AutoDeploymentsEnabled: pulumi.Bool(false),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-service"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port("8000")
 *                         .build())
 *                     .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                     .imageRepositoryType("ECR_PUBLIC")
 *                     .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Service
 *     properties:
 *       serviceName: example
 *       sourceConfiguration:
 *         imageRepository:
 *           imageConfiguration:
 *             port: '8000'
 *           imageIdentifier: public.ecr.aws/aws-containers/hello-app-runner:latest
 *           imageRepositoryType: ECR_PUBLIC
 *         autoDeploymentsEnabled: false
 *       tags:
 *         Name: example-apprunner-service
 * ```
 * <!--End PulumiCodeChooser -->
 * ### Service with Observability Configuration
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const exampleObservabilityConfiguration = new aws.apprunner.ObservabilityConfiguration("example", {
 *     observabilityConfigurationName: "example",
 *     traceConfiguration: {
 *         vendor: "AWSXRAY",
 *     },
 * });
 * const example = new aws.apprunner.Service("example", {
 *     serviceName: "example",
 *     observabilityConfiguration: {
 *         observabilityConfigurationArn: exampleObservabilityConfiguration.arn,
 *         observabilityEnabled: true,
 *     },
 *     sourceConfiguration: {
 *         imageRepository: {
 *             imageConfiguration: {
 *                 port: "8000",
 *             },
 *             imageIdentifier: "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             imageRepositoryType: "ECR_PUBLIC",
 *         },
 *         autoDeploymentsEnabled: false,
 *     },
 *     tags: {
 *         Name: "example-apprunner-service",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example_observability_configuration = aws.apprunner.ObservabilityConfiguration("example",
 *     observability_configuration_name="example",
 *     trace_configuration={
 *         "vendor": "AWSXRAY",
 *     })
 * example = aws.apprunner.Service("example",
 *     service_name="example",
 *     observability_configuration={
 *         "observability_configuration_arn": example_observability_configuration.arn,
 *         "observability_enabled": True,
 *     },
 *     source_configuration={
 *         "image_repository": {
 *             "image_configuration": {
 *                 "port": "8000",
 *             },
 *             "image_identifier": "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *             "image_repository_type": "ECR_PUBLIC",
 *         },
 *         "auto_deployments_enabled": False,
 *     },
 *     tags={
 *         "Name": "example-apprunner-service",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var exampleObservabilityConfiguration = new Aws.AppRunner.ObservabilityConfiguration("example", new()
 *     {
 *         ObservabilityConfigurationName = "example",
 *         TraceConfiguration = new Aws.AppRunner.Inputs.ObservabilityConfigurationTraceConfigurationArgs
 *         {
 *             Vendor = "AWSXRAY",
 *         },
 *     });
 *     var example = new Aws.AppRunner.Service("example", new()
 *     {
 *         ServiceName = "example",
 *         ObservabilityConfiguration = new Aws.AppRunner.Inputs.ServiceObservabilityConfigurationArgs
 *         {
 *             ObservabilityConfigurationArn = exampleObservabilityConfiguration.Arn,
 *             ObservabilityEnabled = true,
 *         },
 *         SourceConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationArgs
 *         {
 *             ImageRepository = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryArgs
 *             {
 *                 ImageConfiguration = new Aws.AppRunner.Inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs
 *                 {
 *                     Port = "8000",
 *                 },
 *                 ImageIdentifier = "public.ecr.aws/aws-containers/hello-app-runner:latest",
 *                 ImageRepositoryType = "ECR_PUBLIC",
 *             },
 *             AutoDeploymentsEnabled = false,
 *         },
 *         Tags =
 *         {
 *             { "Name", "example-apprunner-service" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		exampleObservabilityConfiguration, err := apprunner.NewObservabilityConfiguration(ctx, "example", &apprunner.ObservabilityConfigurationArgs{
 * 			ObservabilityConfigurationName: pulumi.String("example"),
 * 			TraceConfiguration: &apprunner.ObservabilityConfigurationTraceConfigurationArgs{
 * 				Vendor: pulumi.String("AWSXRAY"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = apprunner.NewService(ctx, "example", &apprunner.ServiceArgs{
 * 			ServiceName: pulumi.String("example"),
 * 			ObservabilityConfiguration: &apprunner.ServiceObservabilityConfigurationArgs{
 * 				ObservabilityConfigurationArn: exampleObservabilityConfiguration.Arn,
 * 				ObservabilityEnabled:          pulumi.Bool(true),
 * 			},
 * 			SourceConfiguration: &apprunner.ServiceSourceConfigurationArgs{
 * 				ImageRepository: &apprunner.ServiceSourceConfigurationImageRepositoryArgs{
 * 					ImageConfiguration: &apprunner.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs{
 * 						Port: pulumi.String("8000"),
 * 					},
 * 					ImageIdentifier:     pulumi.String("public.ecr.aws/aws-containers/hello-app-runner:latest"),
 * 					ImageRepositoryType: pulumi.String("ECR_PUBLIC"),
 * 				},
 * 				AutoDeploymentsEnabled: pulumi.Bool(false),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("example-apprunner-service"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.ObservabilityConfiguration;
 * import com.pulumi.aws.apprunner.ObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs;
 * import com.pulumi.aws.apprunner.Service;
 * import com.pulumi.aws.apprunner.ServiceArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryArgs;
 * import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationImageRepositoryImageConfigurationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var exampleObservabilityConfiguration = new ObservabilityConfiguration("exampleObservabilityConfiguration", ObservabilityConfigurationArgs.builder()
 *             .observabilityConfigurationName("example")
 *             .traceConfiguration(ObservabilityConfigurationTraceConfigurationArgs.builder()
 *                 .vendor("AWSXRAY")
 *                 .build())
 *             .build());
 *         var example = new Service("example", ServiceArgs.builder()
 *             .serviceName("example")
 *             .observabilityConfiguration(ServiceObservabilityConfigurationArgs.builder()
 *                 .observabilityConfigurationArn(exampleObservabilityConfiguration.arn())
 *                 .observabilityEnabled(true)
 *                 .build())
 *             .sourceConfiguration(ServiceSourceConfigurationArgs.builder()
 *                 .imageRepository(ServiceSourceConfigurationImageRepositoryArgs.builder()
 *                     .imageConfiguration(ServiceSourceConfigurationImageRepositoryImageConfigurationArgs.builder()
 *                         .port("8000")
 *                         .build())
 *                     .imageIdentifier("public.ecr.aws/aws-containers/hello-app-runner:latest")
 *                     .imageRepositoryType("ECR_PUBLIC")
 *                     .build())
 *                 .autoDeploymentsEnabled(false)
 *                 .build())
 *             .tags(Map.of("Name", "example-apprunner-service"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:apprunner:Service
 *     properties:
 *       serviceName: example
 *       observabilityConfiguration:
 *         observabilityConfigurationArn: ${exampleObservabilityConfiguration.arn}
 *         observabilityEnabled: true
 *       sourceConfiguration:
 *         imageRepository:
 *           imageConfiguration:
 *             port: '8000'
 *           imageIdentifier: public.ecr.aws/aws-containers/hello-app-runner:latest
 *           imageRepositoryType: ECR_PUBLIC
 *         autoDeploymentsEnabled: false
 *       tags:
 *         Name: example-apprunner-service
 *   exampleObservabilityConfiguration:
 *     type: aws:apprunner:ObservabilityConfiguration
 *     name: example
 *     properties:
 *       observabilityConfigurationName: example
 *       traceConfiguration:
 *         vendor: AWSXRAY
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner Services using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:apprunner/service:Service example arn:aws:apprunner:us-east-1:1234567890:service/example/0a03292a89764e5882c41d8f991c82fe
 * ```
 * @property autoScalingConfigurationArn ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
 * @property encryptionConfiguration An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
 * @property healthCheckConfiguration Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
 * @property instanceConfiguration The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
 * @property networkConfiguration Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
 * @property observabilityConfiguration The observability configuration of your service. See Observability Configuration below for more details.
 * @property serviceName Name of the service.
 * @property sourceConfiguration The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
 * The following arguments are optional:
 * @property tags Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 */
public data class ServiceArgs(
    public val autoScalingConfigurationArn: Output<String>? = null,
    public val encryptionConfiguration: Output<ServiceEncryptionConfigurationArgs>? = null,
    public val healthCheckConfiguration: Output<ServiceHealthCheckConfigurationArgs>? = null,
    public val instanceConfiguration: Output<ServiceInstanceConfigurationArgs>? = null,
    public val networkConfiguration: Output<ServiceNetworkConfigurationArgs>? = null,
    public val observabilityConfiguration: Output<ServiceObservabilityConfigurationArgs>? = null,
    public val serviceName: Output<String>? = null,
    public val sourceConfiguration: Output<ServiceSourceConfigurationArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.ServiceArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.ServiceArgs =
        com.pulumi.aws.apprunner.ServiceArgs.builder()
            .autoScalingConfigurationArn(autoScalingConfigurationArn?.applyValue({ args0 -> args0 }))
            .encryptionConfiguration(
                encryptionConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .healthCheckConfiguration(
                healthCheckConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .instanceConfiguration(
                instanceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .networkConfiguration(
                networkConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .observabilityConfiguration(
                observabilityConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .serviceName(serviceName?.applyValue({ args0 -> args0 }))
            .sourceConfiguration(
                sourceConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(
                tags?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            ).build()
}

/**
 * Builder for [ServiceArgs].
 */
@PulumiTagMarker
public class ServiceArgsBuilder internal constructor() {
    private var autoScalingConfigurationArn: Output<String>? = null

    private var encryptionConfiguration: Output<ServiceEncryptionConfigurationArgs>? = null

    private var healthCheckConfiguration: Output<ServiceHealthCheckConfigurationArgs>? = null

    private var instanceConfiguration: Output<ServiceInstanceConfigurationArgs>? = null

    private var networkConfiguration: Output<ServiceNetworkConfigurationArgs>? = null

    private var observabilityConfiguration: Output<ServiceObservabilityConfigurationArgs>? = null

    private var serviceName: Output<String>? = null

    private var sourceConfiguration: Output<ServiceSourceConfigurationArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    /**
     * @param value ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     */
    @JvmName("gagcqpambhbdrswe")
    public suspend fun autoScalingConfigurationArn(`value`: Output<String>) {
        this.autoScalingConfigurationArn = value
    }

    /**
     * @param value An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     */
    @JvmName("buuqttksxrwdsvfy")
    public suspend fun encryptionConfiguration(`value`: Output<ServiceEncryptionConfigurationArgs>) {
        this.encryptionConfiguration = value
    }

    /**
     * @param value Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     */
    @JvmName("qixtkcqwspqiylgw")
    public suspend fun healthCheckConfiguration(`value`: Output<ServiceHealthCheckConfigurationArgs>) {
        this.healthCheckConfiguration = value
    }

    /**
     * @param value The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     */
    @JvmName("bcbsbqjshoybhbln")
    public suspend fun instanceConfiguration(`value`: Output<ServiceInstanceConfigurationArgs>) {
        this.instanceConfiguration = value
    }

    /**
     * @param value Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     */
    @JvmName("okhettsubyutbrqb")
    public suspend fun networkConfiguration(`value`: Output<ServiceNetworkConfigurationArgs>) {
        this.networkConfiguration = value
    }

    /**
     * @param value The observability configuration of your service. See Observability Configuration below for more details.
     */
    @JvmName("ibwspnseyvpqkpbd")
    public suspend fun observabilityConfiguration(`value`: Output<ServiceObservabilityConfigurationArgs>) {
        this.observabilityConfiguration = value
    }

    /**
     * @param value Name of the service.
     */
    @JvmName("xpdymetapliosmyw")
    public suspend fun serviceName(`value`: Output<String>) {
        this.serviceName = value
    }

    /**
     * @param value The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * The following arguments are optional:
     */
    @JvmName("uwqytnamacuhrgjp")
    public suspend fun sourceConfiguration(`value`: Output<ServiceSourceConfigurationArgs>) {
        this.sourceConfiguration = value
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("delrtsqrubqfjnjc")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value ARN of an App Runner automatic scaling configuration resource that you want to associate with your service. If not provided, App Runner associates the latest revision of a default auto scaling configuration.
     */
    @JvmName("fgyqvaxrhycghvwl")
    public suspend fun autoScalingConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoScalingConfigurationArn = mapped
    }

    /**
     * @param value An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     */
    @JvmName("yodpvwsjklgwvwek")
    public suspend fun encryptionConfiguration(`value`: ServiceEncryptionConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.encryptionConfiguration = mapped
    }

    /**
     * @param argument An optional custom encryption key that App Runner uses to encrypt the copy of your source repository that it maintains and your service logs. By default, App Runner uses an AWS managed CMK. See Encryption Configuration below for more details.
     */
    @JvmName("uvntdnomacugewdy")
    public suspend fun encryptionConfiguration(argument: suspend ServiceEncryptionConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceEncryptionConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.encryptionConfiguration = mapped
    }

    /**
     * @param value Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     */
    @JvmName("rastqkeyxobsvkhd")
    public suspend fun healthCheckConfiguration(`value`: ServiceHealthCheckConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.healthCheckConfiguration = mapped
    }

    /**
     * @param argument Settings of the health check that AWS App Runner performs to monitor the health of your service. See Health Check Configuration below for more details.
     */
    @JvmName("dtmgajhvokeqwbqv")
    public suspend fun healthCheckConfiguration(argument: suspend ServiceHealthCheckConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceHealthCheckConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.healthCheckConfiguration = mapped
    }

    /**
     * @param value The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     */
    @JvmName("fyxjjxewmqlbnlci")
    public suspend fun instanceConfiguration(`value`: ServiceInstanceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceConfiguration = mapped
    }

    /**
     * @param argument The runtime configuration of instances (scaling units) of the App Runner service. See Instance Configuration below for more details.
     */
    @JvmName("ncffmtsiebfxoyix")
    public suspend fun instanceConfiguration(argument: suspend ServiceInstanceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceInstanceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.instanceConfiguration = mapped
    }

    /**
     * @param value Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     */
    @JvmName("twhpegsbqiphxwrr")
    public suspend fun networkConfiguration(`value`: ServiceNetworkConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.networkConfiguration = mapped
    }

    /**
     * @param argument Configuration settings related to network traffic of the web application that the App Runner service runs. See Network Configuration below for more details.
     */
    @JvmName("yyejabxqjwxdfnrt")
    public suspend fun networkConfiguration(argument: suspend ServiceNetworkConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceNetworkConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.networkConfiguration = mapped
    }

    /**
     * @param value The observability configuration of your service. See Observability Configuration below for more details.
     */
    @JvmName("ltdtywwyloislfjc")
    public suspend fun observabilityConfiguration(`value`: ServiceObservabilityConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observabilityConfiguration = mapped
    }

    /**
     * @param argument The observability configuration of your service. See Observability Configuration below for more details.
     */
    @JvmName("oleomqitfpegaxyt")
    public suspend fun observabilityConfiguration(argument: suspend ServiceObservabilityConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceObservabilityConfigurationArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.observabilityConfiguration = mapped
    }

    /**
     * @param value Name of the service.
     */
    @JvmName("yvjtwttrdyywvipt")
    public suspend fun serviceName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceName = mapped
    }

    /**
     * @param value The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * The following arguments are optional:
     */
    @JvmName("fwxgerjsqumwbveg")
    public suspend fun sourceConfiguration(`value`: ServiceSourceConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceConfiguration = mapped
    }

    /**
     * @param argument The source to deploy to the App Runner service. Can be a code or an image repository. See Source Configuration below for more details.
     * The following arguments are optional:
     */
    @JvmName("jfnclsgssiucyjas")
    public suspend fun sourceConfiguration(argument: suspend ServiceSourceConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceSourceConfigurationArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.sourceConfiguration = mapped
    }

    /**
     * @param value Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("ipndwatssukvmppp")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("kphcoqewotljpktv")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    internal fun build(): ServiceArgs = ServiceArgs(
        autoScalingConfigurationArn = autoScalingConfigurationArn,
        encryptionConfiguration = encryptionConfiguration,
        healthCheckConfiguration = healthCheckConfiguration,
        instanceConfiguration = instanceConfiguration,
        networkConfiguration = networkConfiguration,
        observabilityConfiguration = observabilityConfiguration,
        serviceName = serviceName,
        sourceConfiguration = sourceConfiguration,
        tags = tags,
    )
}
