@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.Int
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map

/**
 * Builder for [VpcConnector].
 */
@PulumiTagMarker
public class VpcConnectorResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: VpcConnectorArgs = VpcConnectorArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend VpcConnectorArgsBuilder.() -> Unit) {
        val builder = VpcConnectorArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): VpcConnector {
        val builtJavaResource = com.pulumi.aws.apprunner.VpcConnector(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return VpcConnector(builtJavaResource)
    }
}

/**
 * Manages an App Runner VPC Connector.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const connector = new aws.apprunner.VpcConnector("connector", {
 *     vpcConnectorName: "name",
 *     subnets: [
 *         "subnet1",
 *         "subnet2",
 *     ],
 *     securityGroups: [
 *         "sg1",
 *         "sg2",
 *     ],
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * connector = aws.apprunner.VpcConnector("connector",
 *     vpc_connector_name="name",
 *     subnets=[
 *         "subnet1",
 *         "subnet2",
 *     ],
 *     security_groups=[
 *         "sg1",
 *         "sg2",
 *     ])
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var connector = new Aws.AppRunner.VpcConnector("connector", new()
 *     {
 *         VpcConnectorName = "name",
 *         Subnets = new[]
 *         {
 *             "subnet1",
 *             "subnet2",
 *         },
 *         SecurityGroups = new[]
 *         {
 *             "sg1",
 *             "sg2",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/apprunner"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := apprunner.NewVpcConnector(ctx, "connector", &apprunner.VpcConnectorArgs{
 * 			VpcConnectorName: pulumi.String("name"),
 * 			Subnets: pulumi.StringArray{
 * 				pulumi.String("subnet1"),
 * 				pulumi.String("subnet2"),
 * 			},
 * 			SecurityGroups: pulumi.StringArray{
 * 				pulumi.String("sg1"),
 * 				pulumi.String("sg2"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.apprunner.VpcConnector;
 * import com.pulumi.aws.apprunner.VpcConnectorArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var connector = new VpcConnector("connector", VpcConnectorArgs.builder()
 *             .vpcConnectorName("name")
 *             .subnets(
 *                 "subnet1",
 *                 "subnet2")
 *             .securityGroups(
 *                 "sg1",
 *                 "sg2")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   connector:
 *     type: aws:apprunner:VpcConnector
 *     properties:
 *       vpcConnectorName: name
 *       subnets:
 *         - subnet1
 *         - subnet2
 *       securityGroups:
 *         - sg1
 *         - sg2
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import App Runner vpc connector using the `arn`. For example:
 * ```sh
 * $ pulumi import aws:apprunner/vpcConnector:VpcConnector example arn:aws:apprunner:us-east-1:1234567890:vpcconnector/example/1/0a03292a89764e5882c41d8f991c82fe
 * ```
 */
public class VpcConnector internal constructor(
    override val javaResource: com.pulumi.aws.apprunner.VpcConnector,
) : KotlinCustomResource(javaResource, VpcConnectorMapper) {
    /**
     * ARN of VPC connector.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * List of IDs of security groups that App Runner should use for access to AWS resources under the specified subnets. If not specified, App Runner uses the default security group of the Amazon VPC. The default security group allows all outbound traffic.
     */
    public val securityGroups: Output<List<String>>
        get() = javaResource.securityGroups().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Current state of the VPC connector. If the status of a connector revision is INACTIVE, it was deleted and can't be used. Inactive connector revisions are permanently removed some time after they are deleted.
     */
    public val status: Output<String>
        get() = javaResource.status().applyValue({ args0 -> args0 })

    /**
     * List of IDs of subnets that App Runner should use when it associates your service with a custom Amazon VPC. Specify IDs of subnets of a single Amazon VPC. App Runner determines the Amazon VPC from the subnets you specify.
     */
    public val subnets: Output<List<String>>
        get() = javaResource.subnets().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * Key-value map of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Name for the VPC connector.
     */
    public val vpcConnectorName: Output<String>
        get() = javaResource.vpcConnectorName().applyValue({ args0 -> args0 })

    /**
     * The revision of VPC connector. It's unique among all the active connectors ("Status": "ACTIVE") that share the same Name.
     */
    public val vpcConnectorRevision: Output<Int>
        get() = javaResource.vpcConnectorRevision().applyValue({ args0 -> args0 })
}

public object VpcConnectorMapper : ResourceMapper<VpcConnector> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.apprunner.VpcConnector::class == javaResource::class

    override fun map(javaResource: Resource): VpcConnector = VpcConnector(
        javaResource as
            com.pulumi.aws.apprunner.VpcConnector,
    )
}

/**
 * @see [VpcConnector].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [VpcConnector].
 */
public suspend fun vpcConnector(
    name: String,
    block: suspend VpcConnectorResourceBuilder.() -> Unit,
): VpcConnector {
    val builder = VpcConnectorResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [VpcConnector].
 * @param name The _unique_ name of the resulting resource.
 */
public fun vpcConnector(name: String): VpcConnector {
    val builder = VpcConnectorResourceBuilder()
    builder.name(name)
    return builder.build()
}
