@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.DeploymentTimeoutsArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property create A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
 */
public data class DeploymentTimeoutsArgs(
    public val create: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.DeploymentTimeoutsArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.DeploymentTimeoutsArgs =
        com.pulumi.aws.apprunner.inputs.DeploymentTimeoutsArgs.builder()
            .create(create?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [DeploymentTimeoutsArgs].
 */
@PulumiTagMarker
public class DeploymentTimeoutsArgsBuilder internal constructor() {
    private var create: Output<String>? = null

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("iumkgkjederlfxfw")
    public suspend fun create(`value`: Output<String>) {
        this.create = value
    }

    /**
     * @param value A string that can be [parsed as a duration](https://pkg.go.dev/time#ParseDuration) consisting of numbers and unit suffixes, such as "30s" or "2h45m". Valid time units are "s" (seconds), "m" (minutes), "h" (hours).
     */
    @JvmName("prtnaepxviixqkwf")
    public suspend fun create(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.create = mapped
    }

    internal fun build(): DeploymentTimeoutsArgs = DeploymentTimeoutsArgs(
        create = create,
    )
}
