@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vendor Implementation provider chosen for tracing App Runner services. Valid values: `AWSXRAY`.
 */
public data class ObservabilityConfigurationTraceConfigurationArgs(
    public val vendor: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ObservabilityConfigurationTraceConfigurationArgs.builder()
            .vendor(vendor?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ObservabilityConfigurationTraceConfigurationArgs].
 */
@PulumiTagMarker
public class ObservabilityConfigurationTraceConfigurationArgsBuilder internal constructor() {
    private var vendor: Output<String>? = null

    /**
     * @param value Implementation provider chosen for tracing App Runner services. Valid values: `AWSXRAY`.
     */
    @JvmName("cqjtkvxumoxijfnu")
    public suspend fun vendor(`value`: Output<String>) {
        this.vendor = value
    }

    /**
     * @param value Implementation provider chosen for tracing App Runner services. Valid values: `AWSXRAY`.
     */
    @JvmName("dpyeyexxaggpuixm")
    public suspend fun vendor(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vendor = mapped
    }

    internal fun build(): ObservabilityConfigurationTraceConfigurationArgs =
        ObservabilityConfigurationTraceConfigurationArgs(
            vendor = vendor,
        )
}
