@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property observabilityConfigurationArn ARN of the observability configuration that is associated with the service. Specified only when `observability_enabled` is `true`.
 * @property observabilityEnabled When `true`, an observability configuration resource is associated with the service.
 */
public data class ServiceObservabilityConfigurationArgs(
    public val observabilityConfigurationArn: Output<String>? = null,
    public val observabilityEnabled: Output<Boolean>,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceObservabilityConfigurationArgs.builder()
            .observabilityConfigurationArn(observabilityConfigurationArn?.applyValue({ args0 -> args0 }))
            .observabilityEnabled(observabilityEnabled.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceObservabilityConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceObservabilityConfigurationArgsBuilder internal constructor() {
    private var observabilityConfigurationArn: Output<String>? = null

    private var observabilityEnabled: Output<Boolean>? = null

    /**
     * @param value ARN of the observability configuration that is associated with the service. Specified only when `observability_enabled` is `true`.
     */
    @JvmName("hqeibdwphmgrnrnf")
    public suspend fun observabilityConfigurationArn(`value`: Output<String>) {
        this.observabilityConfigurationArn = value
    }

    /**
     * @param value When `true`, an observability configuration resource is associated with the service.
     */
    @JvmName("fejgbapgwiaxdhhr")
    public suspend fun observabilityEnabled(`value`: Output<Boolean>) {
        this.observabilityEnabled = value
    }

    /**
     * @param value ARN of the observability configuration that is associated with the service. Specified only when `observability_enabled` is `true`.
     */
    @JvmName("cdmewbjxjenramid")
    public suspend fun observabilityConfigurationArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.observabilityConfigurationArn = mapped
    }

    /**
     * @param value When `true`, an observability configuration resource is associated with the service.
     */
    @JvmName("yvicpejxvalbstbg")
    public suspend fun observabilityEnabled(`value`: Boolean) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.observabilityEnabled = mapped
    }

    internal fun build(): ServiceObservabilityConfigurationArgs =
        ServiceObservabilityConfigurationArgs(
            observabilityConfigurationArn = observabilityConfigurationArn,
            observabilityEnabled = observabilityEnabled ?: throw
                PulumiNullFieldException("observabilityEnabled"),
        )
}
