@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property authenticationConfiguration Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
 * @property autoDeploymentsEnabled Whether continuous integration from the source repository is enabled for the App Runner service. If set to `true`, each repository change (source code commit or new image version) starts a deployment. Defaults to `true`.
 * @property codeRepository Description of a source code repository. See Code Repository below for more details.
 * @property imageRepository Description of a source image repository. See Image Repository below for more details.
 */
public data class ServiceSourceConfigurationArgs(
    public val authenticationConfiguration: Output<ServiceSourceConfigurationAuthenticationConfigurationArgs>? = null,
    public val autoDeploymentsEnabled: Output<Boolean>? = null,
    public val codeRepository: Output<ServiceSourceConfigurationCodeRepositoryArgs>? = null,
    public val imageRepository: Output<ServiceSourceConfigurationImageRepositoryArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationArgs.builder()
            .authenticationConfiguration(
                authenticationConfiguration?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .autoDeploymentsEnabled(autoDeploymentsEnabled?.applyValue({ args0 -> args0 }))
            .codeRepository(codeRepository?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .imageRepository(
                imageRepository?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [ServiceSourceConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationArgsBuilder internal constructor() {
    private var authenticationConfiguration:
        Output<ServiceSourceConfigurationAuthenticationConfigurationArgs>? = null

    private var autoDeploymentsEnabled: Output<Boolean>? = null

    private var codeRepository: Output<ServiceSourceConfigurationCodeRepositoryArgs>? = null

    private var imageRepository: Output<ServiceSourceConfigurationImageRepositoryArgs>? = null

    /**
     * @param value Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
     */
    @JvmName("daslesrcqarrqpkv")
    public suspend fun authenticationConfiguration(`value`: Output<ServiceSourceConfigurationAuthenticationConfigurationArgs>) {
        this.authenticationConfiguration = value
    }

    /**
     * @param value Whether continuous integration from the source repository is enabled for the App Runner service. If set to `true`, each repository change (source code commit or new image version) starts a deployment. Defaults to `true`.
     */
    @JvmName("wfoyxscgwxbmxgwy")
    public suspend fun autoDeploymentsEnabled(`value`: Output<Boolean>) {
        this.autoDeploymentsEnabled = value
    }

    /**
     * @param value Description of a source code repository. See Code Repository below for more details.
     */
    @JvmName("nbnaddnfloswywgt")
    public suspend fun codeRepository(`value`: Output<ServiceSourceConfigurationCodeRepositoryArgs>) {
        this.codeRepository = value
    }

    /**
     * @param value Description of a source image repository. See Image Repository below for more details.
     */
    @JvmName("jfholmpievbibvkf")
    public suspend fun imageRepository(`value`: Output<ServiceSourceConfigurationImageRepositoryArgs>) {
        this.imageRepository = value
    }

    /**
     * @param value Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
     */
    @JvmName("srglfyygrqcxksxv")
    public suspend fun authenticationConfiguration(`value`: ServiceSourceConfigurationAuthenticationConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationConfiguration = mapped
    }

    /**
     * @param argument Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
     */
    @JvmName("elwwmatloijukmwu")
    public suspend fun authenticationConfiguration(argument: suspend ServiceSourceConfigurationAuthenticationConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceSourceConfigurationAuthenticationConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.authenticationConfiguration = mapped
    }

    /**
     * @param value Whether continuous integration from the source repository is enabled for the App Runner service. If set to `true`, each repository change (source code commit or new image version) starts a deployment. Defaults to `true`.
     */
    @JvmName("xkpjytoueqaaakia")
    public suspend fun autoDeploymentsEnabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.autoDeploymentsEnabled = mapped
    }

    /**
     * @param value Description of a source code repository. See Code Repository below for more details.
     */
    @JvmName("dbnnijrtxqoekncu")
    public suspend fun codeRepository(`value`: ServiceSourceConfigurationCodeRepositoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeRepository = mapped
    }

    /**
     * @param argument Description of a source code repository. See Code Repository below for more details.
     */
    @JvmName("vtkfdxqpiqfefvui")
    public suspend fun codeRepository(argument: suspend ServiceSourceConfigurationCodeRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceSourceConfigurationCodeRepositoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.codeRepository = mapped
    }

    /**
     * @param value Description of a source image repository. See Image Repository below for more details.
     */
    @JvmName("oupctdlqqamqepew")
    public suspend fun imageRepository(`value`: ServiceSourceConfigurationImageRepositoryArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageRepository = mapped
    }

    /**
     * @param argument Description of a source image repository. See Image Repository below for more details.
     */
    @JvmName("ciruicwmftjlbflx")
    public suspend fun imageRepository(argument: suspend ServiceSourceConfigurationImageRepositoryArgsBuilder.() -> Unit) {
        val toBeMapped = ServiceSourceConfigurationImageRepositoryArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.imageRepository = mapped
    }

    internal fun build(): ServiceSourceConfigurationArgs = ServiceSourceConfigurationArgs(
        authenticationConfiguration = authenticationConfiguration,
        autoDeploymentsEnabled = autoDeploymentsEnabled,
        codeRepository = codeRepository,
        imageRepository = imageRepository,
    )
}
