@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property accessRoleArn ARN of the IAM role that grants the App Runner service access to a source repository. Required for ECR image repositories (but not for ECR Public)
 * @property connectionArn ARN of the App Runner connection that enables the App Runner service to connect to a source repository. Required for GitHub code repositories.
 */
public data class ServiceSourceConfigurationAuthenticationConfigurationArgs(
    public val accessRoleArn: Output<String>? = null,
    public val connectionArn: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationAuthenticationConfigurationArgs.builder()
            .accessRoleArn(accessRoleArn?.applyValue({ args0 -> args0 }))
            .connectionArn(connectionArn?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationAuthenticationConfigurationArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationAuthenticationConfigurationArgsBuilder internal constructor() {
    private var accessRoleArn: Output<String>? = null

    private var connectionArn: Output<String>? = null

    /**
     * @param value ARN of the IAM role that grants the App Runner service access to a source repository. Required for ECR image repositories (but not for ECR Public)
     */
    @JvmName("bfymatotsyhxouws")
    public suspend fun accessRoleArn(`value`: Output<String>) {
        this.accessRoleArn = value
    }

    /**
     * @param value ARN of the App Runner connection that enables the App Runner service to connect to a source repository. Required for GitHub code repositories.
     */
    @JvmName("vvwxwptayxbveyuc")
    public suspend fun connectionArn(`value`: Output<String>) {
        this.connectionArn = value
    }

    /**
     * @param value ARN of the IAM role that grants the App Runner service access to a source repository. Required for ECR image repositories (but not for ECR Public)
     */
    @JvmName("qbapvroyljggqhnl")
    public suspend fun accessRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessRoleArn = mapped
    }

    /**
     * @param value ARN of the App Runner connection that enables the App Runner service to connect to a source repository. Required for GitHub code repositories.
     */
    @JvmName("lpuwcrlfsllulipj")
    public suspend fun connectionArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.connectionArn = mapped
    }

    internal fun build(): ServiceSourceConfigurationAuthenticationConfigurationArgs =
        ServiceSourceConfigurationAuthenticationConfigurationArgs(
            accessRoleArn = accessRoleArn,
            connectionArn = connectionArn,
        )
}
