@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.jvm.JvmName

/**
 *
 * @property codeConfiguration Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
 * @property repositoryUrl Location of the repository that contains the source code.
 * @property sourceCodeVersion Version that should be used within the source code repository. See Source Code Version below for more details.
 * @property sourceDirectory The path of the directory that stores source code and configuration files. The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
 */
public data class ServiceSourceConfigurationCodeRepositoryArgs(
    public val codeConfiguration: Output<ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs>? = null,
    public val repositoryUrl: Output<String>,
    public val sourceCodeVersion: Output<ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs>,
    public val sourceDirectory: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryArgs.builder()
            .codeConfiguration(codeConfiguration?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .repositoryUrl(repositoryUrl.applyValue({ args0 -> args0 }))
            .sourceCodeVersion(sourceCodeVersion.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .sourceDirectory(sourceDirectory?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationCodeRepositoryArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationCodeRepositoryArgsBuilder internal constructor() {
    private var codeConfiguration:
        Output<ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs>? = null

    private var repositoryUrl: Output<String>? = null

    private var sourceCodeVersion:
        Output<ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs>? = null

    private var sourceDirectory: Output<String>? = null

    /**
     * @param value Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
     */
    @JvmName("raxpisbalcfddhno")
    public suspend fun codeConfiguration(`value`: Output<ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs>) {
        this.codeConfiguration = value
    }

    /**
     * @param value Location of the repository that contains the source code.
     */
    @JvmName("fowjobqytvwvfnaa")
    public suspend fun repositoryUrl(`value`: Output<String>) {
        this.repositoryUrl = value
    }

    /**
     * @param value Version that should be used within the source code repository. See Source Code Version below for more details.
     */
    @JvmName("qjsfytqqaoahqaxo")
    public suspend fun sourceCodeVersion(`value`: Output<ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs>) {
        this.sourceCodeVersion = value
    }

    /**
     * @param value The path of the directory that stores source code and configuration files. The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
     */
    @JvmName("fpgwyeuflrgtosyt")
    public suspend fun sourceDirectory(`value`: Output<String>) {
        this.sourceDirectory = value
    }

    /**
     * @param value Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
     */
    @JvmName("bnpimylecuxhtpbo")
    public suspend fun codeConfiguration(`value`: ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.codeConfiguration = mapped
    }

    /**
     * @param argument Configuration for building and running the service from a source code repository. See Code Configuration below for more details.
     */
    @JvmName("ypgrathcxicspsft")
    public suspend fun codeConfiguration(argument: suspend ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceSourceConfigurationCodeRepositoryCodeConfigurationArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.codeConfiguration = mapped
    }

    /**
     * @param value Location of the repository that contains the source code.
     */
    @JvmName("rbmgoasqnbwlwure")
    public suspend fun repositoryUrl(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.repositoryUrl = mapped
    }

    /**
     * @param value Version that should be used within the source code repository. See Source Code Version below for more details.
     */
    @JvmName("ddobxdivatxdejhn")
    public suspend fun sourceCodeVersion(`value`: ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.sourceCodeVersion = mapped
    }

    /**
     * @param argument Version that should be used within the source code repository. See Source Code Version below for more details.
     */
    @JvmName("hgismyfdnhlohxaq")
    public suspend fun sourceCodeVersion(argument: suspend ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgsBuilder.() -> Unit) {
        val toBeMapped =
            ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgsBuilder().applySuspend {
                argument()
            }.build()
        val mapped = of(toBeMapped)
        this.sourceCodeVersion = mapped
    }

    /**
     * @param value The path of the directory that stores source code and configuration files. The build and start commands also execute from here. The path is absolute from root and, if not specified, defaults to the repository root.
     */
    @JvmName("kokbcvcnvyutqqxk")
    public suspend fun sourceDirectory(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sourceDirectory = mapped
    }

    internal fun build(): ServiceSourceConfigurationCodeRepositoryArgs =
        ServiceSourceConfigurationCodeRepositoryArgs(
            codeConfiguration = codeConfiguration,
            repositoryUrl = repositoryUrl ?: throw PulumiNullFieldException("repositoryUrl"),
            sourceCodeVersion = sourceCodeVersion ?: throw PulumiNullFieldException("sourceCodeVersion"),
            sourceDirectory = sourceDirectory,
        )
}
