@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 *
 * @property buildCommand Command App Runner runs to build your application.
 * @property port Port that your application listens to in the container. Defaults to `"8080"`.
 * @property runtime Runtime environment type for building and running an App Runner service. Represents a programming language runtime. Valid values: `PYTHON_3`, `NODEJS_12`, `NODEJS_14`, `NODEJS_16`, `CORRETTO_8`, `CORRETTO_11`, `GO_1`, `DOTNET_6`, `PHP_81`, `RUBY_31`.
 * @property runtimeEnvironmentSecrets Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
 * @property runtimeEnvironmentVariables Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
 * @property startCommand Command App Runner runs to start your application.
 */
public data class
ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs(
    public val buildCommand: Output<String>? = null,
    public val port: Output<String>? = null,
    public val runtime: Output<String>,
    public val runtimeEnvironmentSecrets: Output<Map<String, String>>? = null,
    public val runtimeEnvironmentVariables: Output<Map<String, String>>? = null,
    public val startCommand: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs.builder()
            .buildCommand(buildCommand?.applyValue({ args0 -> args0 }))
            .port(port?.applyValue({ args0 -> args0 }))
            .runtime(runtime.applyValue({ args0 -> args0 }))
            .runtimeEnvironmentSecrets(
                runtimeEnvironmentSecrets?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .runtimeEnvironmentVariables(
                runtimeEnvironmentVariables?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.key.to(args0.value)
                    }).toMap()
                }),
            )
            .startCommand(startCommand?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs].
 */
@PulumiTagMarker
public class
ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgsBuilder
internal constructor() {
    private var buildCommand: Output<String>? = null

    private var port: Output<String>? = null

    private var runtime: Output<String>? = null

    private var runtimeEnvironmentSecrets: Output<Map<String, String>>? = null

    private var runtimeEnvironmentVariables: Output<Map<String, String>>? = null

    private var startCommand: Output<String>? = null

    /**
     * @param value Command App Runner runs to build your application.
     */
    @JvmName("gghsbuwgiqkhetig")
    public suspend fun buildCommand(`value`: Output<String>) {
        this.buildCommand = value
    }

    /**
     * @param value Port that your application listens to in the container. Defaults to `"8080"`.
     */
    @JvmName("mhypdrjvxtblhvls")
    public suspend fun port(`value`: Output<String>) {
        this.port = value
    }

    /**
     * @param value Runtime environment type for building and running an App Runner service. Represents a programming language runtime. Valid values: `PYTHON_3`, `NODEJS_12`, `NODEJS_14`, `NODEJS_16`, `CORRETTO_8`, `CORRETTO_11`, `GO_1`, `DOTNET_6`, `PHP_81`, `RUBY_31`.
     */
    @JvmName("mceasxljwjpmlnse")
    public suspend fun runtime(`value`: Output<String>) {
        this.runtime = value
    }

    /**
     * @param value Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
     */
    @JvmName("hwxkpjkhsecwpots")
    public suspend fun runtimeEnvironmentSecrets(`value`: Output<Map<String, String>>) {
        this.runtimeEnvironmentSecrets = value
    }

    /**
     * @param value Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
     */
    @JvmName("seyvefikjcajpibk")
    public suspend fun runtimeEnvironmentVariables(`value`: Output<Map<String, String>>) {
        this.runtimeEnvironmentVariables = value
    }

    /**
     * @param value Command App Runner runs to start your application.
     */
    @JvmName("vaoubcuhqebinajo")
    public suspend fun startCommand(`value`: Output<String>) {
        this.startCommand = value
    }

    /**
     * @param value Command App Runner runs to build your application.
     */
    @JvmName("hdieesvnmlyuqdwd")
    public suspend fun buildCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.buildCommand = mapped
    }

    /**
     * @param value Port that your application listens to in the container. Defaults to `"8080"`.
     */
    @JvmName("ivkwkjhndnoogaoy")
    public suspend fun port(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.port = mapped
    }

    /**
     * @param value Runtime environment type for building and running an App Runner service. Represents a programming language runtime. Valid values: `PYTHON_3`, `NODEJS_12`, `NODEJS_14`, `NODEJS_16`, `CORRETTO_8`, `CORRETTO_11`, `GO_1`, `DOTNET_6`, `PHP_81`, `RUBY_31`.
     */
    @JvmName("wpyssjlsnmqtpuxx")
    public suspend fun runtime(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtime = mapped
    }

    /**
     * @param value Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
     */
    @JvmName("ejhcinsbjealjuhr")
    public suspend fun runtimeEnvironmentSecrets(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironmentSecrets = mapped
    }

    /**
     * @param values Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
     */
    @JvmName("dmlsngwcpmtstuua")
    public fun runtimeEnvironmentSecrets(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeEnvironmentSecrets = mapped
    }

    /**
     * @param value Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
     */
    @JvmName("eymybilnxjuqwujw")
    public suspend fun runtimeEnvironmentVariables(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.runtimeEnvironmentVariables = mapped
    }

    /**
     * @param values Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
     */
    @JvmName("swpknyvifcrjwixl")
    public fun runtimeEnvironmentVariables(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.runtimeEnvironmentVariables = mapped
    }

    /**
     * @param value Command App Runner runs to start your application.
     */
    @JvmName("ibuoghpnbxkknfua")
    public suspend fun startCommand(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.startCommand = mapped
    }

    internal fun build(): ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs =
        ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValuesArgs(
            buildCommand = buildCommand,
            port = port,
            runtime = runtime ?: throw PulumiNullFieldException("runtime"),
            runtimeEnvironmentSecrets = runtimeEnvironmentSecrets,
            runtimeEnvironmentVariables = runtimeEnvironmentVariables,
            startCommand = startCommand,
        )
}
