@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiNullFieldException
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property type Type of version identifier. For a git-based repository, branches represent versions. Valid values: `BRANCH`.
 * @property value Source code version. For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
 */
public data class ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs(
    public val type: Output<String>,
    public val `value`: Output<String>,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs =
        com.pulumi.aws.apprunner.inputs.ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs.builder()
            .type(type.applyValue({ args0 -> args0 }))
            .`value`(`value`.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs].
 */
@PulumiTagMarker
public class ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgsBuilder internal constructor() {
    private var type: Output<String>? = null

    private var `value`: Output<String>? = null

    /**
     * @param value Type of version identifier. For a git-based repository, branches represent versions. Valid values: `BRANCH`.
     */
    @JvmName("oyelujwcuvhiveij")
    public suspend fun type(`value`: Output<String>) {
        this.type = value
    }

    /**
     * @param value Source code version. For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
     */
    @JvmName("tajnkuvquxgknomq")
    public suspend fun `value`(`value`: Output<String>) {
        this.`value` = value
    }

    /**
     * @param value Type of version identifier. For a git-based repository, branches represent versions. Valid values: `BRANCH`.
     */
    @JvmName("videbulwaoqtsuew")
    public suspend fun type(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.type = mapped
    }

    /**
     * @param value Source code version. For a git-based repository, a branch name maps to a specific version. App Runner uses the most recent commit to the branch.
     */
    @JvmName("rqdaeysothskpqjn")
    public suspend fun `value`(`value`: String) {
        val toBeMapped = value
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.`value` = mapped
    }

    internal fun build(): ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs =
        ServiceSourceConfigurationCodeRepositorySourceCodeVersionArgs(
            type = type ?: throw PulumiNullFieldException("type"),
            `value` = `value` ?: throw PulumiNullFieldException("value"),
        )
}
