@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.inputs

import com.pulumi.aws.apprunner.inputs.VpcIngressConnectionIngressVpcConfigurationArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property vpcEndpointId The ID of the VPC endpoint that your App Runner service connects to.
 * @property vpcId The ID of the VPC that is used for the VPC endpoint.
 */
public data class VpcIngressConnectionIngressVpcConfigurationArgs(
    public val vpcEndpointId: Output<String>? = null,
    public val vpcId: Output<String>? = null,
) :
    ConvertibleToJava<com.pulumi.aws.apprunner.inputs.VpcIngressConnectionIngressVpcConfigurationArgs> {
    override fun toJava(): com.pulumi.aws.apprunner.inputs.VpcIngressConnectionIngressVpcConfigurationArgs =
        com.pulumi.aws.apprunner.inputs.VpcIngressConnectionIngressVpcConfigurationArgs.builder()
            .vpcEndpointId(vpcEndpointId?.applyValue({ args0 -> args0 }))
            .vpcId(vpcId?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [VpcIngressConnectionIngressVpcConfigurationArgs].
 */
@PulumiTagMarker
public class VpcIngressConnectionIngressVpcConfigurationArgsBuilder internal constructor() {
    private var vpcEndpointId: Output<String>? = null

    private var vpcId: Output<String>? = null

    /**
     * @param value The ID of the VPC endpoint that your App Runner service connects to.
     */
    @JvmName("jygkfyukwnbkmhsk")
    public suspend fun vpcEndpointId(`value`: Output<String>) {
        this.vpcEndpointId = value
    }

    /**
     * @param value The ID of the VPC that is used for the VPC endpoint.
     */
    @JvmName("uuexsxinlajyklwv")
    public suspend fun vpcId(`value`: Output<String>) {
        this.vpcId = value
    }

    /**
     * @param value The ID of the VPC endpoint that your App Runner service connects to.
     */
    @JvmName("pjdukdpftnihuxmi")
    public suspend fun vpcEndpointId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcEndpointId = mapped
    }

    /**
     * @param value The ID of the VPC that is used for the VPC endpoint.
     */
    @JvmName("tiapinslpcavhytb")
    public suspend fun vpcId(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcId = mapped
    }

    internal fun build(): VpcIngressConnectionIngressVpcConfigurationArgs =
        VpcIngressConnectionIngressVpcConfigurationArgs(
            vpcEndpointId = vpcEndpointId,
            vpcId = vpcId,
        )
}
