@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property name Certificate CNAME record name.
 * @property status Current state of the certificate CNAME record validation. It should change to `SUCCESS` after App Runner completes validation with your DNS.
 * @property type Record type, always `CNAME`.
 * @property value Certificate CNAME record value.
 */
public data class CustomDomainAssociationCertificateValidationRecord(
    public val name: String? = null,
    public val status: String? = null,
    public val type: String? = null,
    public val `value`: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.CustomDomainAssociationCertificateValidationRecord): CustomDomainAssociationCertificateValidationRecord =
            CustomDomainAssociationCertificateValidationRecord(
                name = javaType.name().map({ args0 -> args0 }).orElse(null),
                status = javaType.status().map({ args0 -> args0 }).orElse(null),
                type = javaType.type().map({ args0 -> args0 }).orElse(null),
                `value` = javaType.`value`().map({ args0 -> args0 }).orElse(null),
            )
    }
}
