@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 * A collection of values returned by getHostedZoneId.
 * @property id ID of the AWS App Runner service HostedZoneId in the selected region.
 * @property region
 */
public data class GetHostedZoneIdResult(
    public val id: String,
    public val region: String,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.GetHostedZoneIdResult): GetHostedZoneIdResult = GetHostedZoneIdResult(
            id = javaType.id(),
            region = javaType.region(),
        )
    }
}
