@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress

/**
 *
 * @property cpu Number of CPU units reserved for each instance of your App Runner service represented as a String. Defaults to `1024`. Valid values: `256|512|1024|2048|4096|(0.25|0.5|1|2|4) vCPU`.
 * @property instanceRoleArn ARN of an IAM role that provides permissions to your App Runner service. These are permissions that your code needs when it calls any AWS APIs.
 * @property memory Amount of memory, in MB or GB, reserved for each instance of your App Runner service. Defaults to `2048`. Valid values: `512|1024|2048|3072|4096|6144|8192|10240|12288|(0.5|1|2|3|4|6|8|10|12) GB`.
 */
public data class ServiceInstanceConfiguration(
    public val cpu: String? = null,
    public val instanceRoleArn: String? = null,
    public val memory: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceInstanceConfiguration): ServiceInstanceConfiguration = ServiceInstanceConfiguration(
            cpu = javaType.cpu().map({ args0 -> args0 }).orElse(null),
            instanceRoleArn = javaType.instanceRoleArn().map({ args0 -> args0 }).orElse(null),
            memory = javaType.memory().map({ args0 -> args0 }).orElse(null),
        )
    }
}
