@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property isPubliclyAccessible Specifies whether your App Runner service is publicly accessible. To make the service publicly accessible set it to True. To make the service privately accessible, from only within an Amazon VPC set it to False.
 */
public data class ServiceNetworkConfigurationIngressConfiguration(
    public val isPubliclyAccessible: Boolean? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceNetworkConfigurationIngressConfiguration): ServiceNetworkConfigurationIngressConfiguration =
            ServiceNetworkConfigurationIngressConfiguration(
                isPubliclyAccessible = javaType.isPubliclyAccessible().map({ args0 -> args0 }).orElse(null),
            )
    }
}
