@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.Boolean
import kotlin.Suppress

/**
 *
 * @property authenticationConfiguration Describes resources needed to authenticate access to some source repositories. See Authentication Configuration below for more details.
 * @property autoDeploymentsEnabled Whether continuous integration from the source repository is enabled for the App Runner service. If set to `true`, each repository change (source code commit or new image version) starts a deployment. Defaults to `true`.
 * @property codeRepository Description of a source code repository. See Code Repository below for more details.
 * @property imageRepository Description of a source image repository. See Image Repository below for more details.
 */
public data class ServiceSourceConfiguration(
    public val authenticationConfiguration: ServiceSourceConfigurationAuthenticationConfiguration? =
        null,
    public val autoDeploymentsEnabled: Boolean? = null,
    public val codeRepository: ServiceSourceConfigurationCodeRepository? = null,
    public val imageRepository: ServiceSourceConfigurationImageRepository? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfiguration): ServiceSourceConfiguration = ServiceSourceConfiguration(
            authenticationConfiguration = javaType.authenticationConfiguration().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationAuthenticationConfiguration.Companion.toKotlin(args0)
                })
            }).orElse(null),
            autoDeploymentsEnabled = javaType.autoDeploymentsEnabled().map({ args0 -> args0 }).orElse(null),
            codeRepository = javaType.codeRepository().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationCodeRepository.Companion.toKotlin(args0)
                })
            }).orElse(null),
            imageRepository = javaType.imageRepository().map({ args0 ->
                args0.let({ args0 ->
                    com.pulumi.aws.apprunner.kotlin.outputs.ServiceSourceConfigurationImageRepository.Companion.toKotlin(args0)
                })
            }).orElse(null),
        )
    }
}
