@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.apprunner.kotlin.outputs

import kotlin.String
import kotlin.Suppress
import kotlin.collections.Map

/**
 *
 * @property buildCommand Command App Runner runs to build your application.
 * @property port Port that your application listens to in the container. Defaults to `"8080"`.
 * @property runtime Runtime environment type for building and running an App Runner service. Represents a programming language runtime. Valid values: `PYTHON_3`, `NODEJS_12`, `NODEJS_14`, `NODEJS_16`, `CORRETTO_8`, `CORRETTO_11`, `GO_1`, `DOTNET_6`, `PHP_81`, `RUBY_31`.
 * @property runtimeEnvironmentSecrets Secrets and parameters available to your service as environment variables. A map of key/value pairs, where the key is the desired name of the Secret in the environment (i.e. it does not have to match the name of the secret in Secrets Manager or SSM Parameter Store), and the value is the ARN of the secret from AWS Secrets Manager or the ARN of the parameter in AWS SSM Parameter Store.
 * @property runtimeEnvironmentVariables Environment variables available to your running App Runner service. A map of key/value pairs. Keys with a prefix of `AWSAPPRUNNER` are reserved for system use and aren't valid.
 * @property startCommand Command App Runner runs to start your application.
 */
public data class ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues(
    public val buildCommand: String? = null,
    public val port: String? = null,
    public val runtime: String,
    public val runtimeEnvironmentSecrets: Map<String, String>? = null,
    public val runtimeEnvironmentVariables: Map<String, String>? = null,
    public val startCommand: String? = null,
) {
    public companion object {
        public fun toKotlin(javaType: com.pulumi.aws.apprunner.outputs.ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues): ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues =
            ServiceSourceConfigurationCodeRepositoryCodeConfigurationCodeConfigurationValues(
                buildCommand = javaType.buildCommand().map({ args0 -> args0 }).orElse(null),
                port = javaType.port().map({ args0 -> args0 }).orElse(null),
                runtime = javaType.runtime(),
                runtimeEnvironmentSecrets = javaType.runtimeEnvironmentSecrets().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                runtimeEnvironmentVariables = javaType.runtimeEnvironmentVariables().map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap(),
                startCommand = javaType.startCommand().map({ args0 -> args0 }).orElse(null),
            )
    }
}
