@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.AppstreamFunctions.getImagePlain
import com.pulumi.aws.appstream.kotlin.inputs.GetImagePlainArgs
import com.pulumi.aws.appstream.kotlin.inputs.GetImagePlainArgsBuilder
import com.pulumi.aws.appstream.kotlin.outputs.GetImageResult
import com.pulumi.aws.appstream.kotlin.outputs.GetImageResult.Companion.toKotlin
import kotlinx.coroutines.future.await
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

public object AppstreamFunctions {
    /**
     * Data source for managing an AWS AppStream 2.0 Image.
     * @param argument A collection of arguments for invoking getImage.
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: GetImagePlainArgs): GetImageResult =
        toKotlin(getImagePlain(argument.toJava()).await())

    /**
     * @see [getImage].
     * @param arn Arn of the image being searched for. Cannot be used with name_regex or name.
     * @param mostRecent Boolean that if it is set to true and there are multiple images returned the most recent will be returned. If it is set to false and there are multiple images return the datasource will error.
     * @param name Name of the image being searched for. Cannot be used with name_regex or arn.
     * @param nameRegex Regular expression name of the image being searched for. Cannot be used with arn or name.
     * @param type The type of image which must be (PUBLIC, PRIVATE, or SHARED).
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(
        arn: String? = null,
        mostRecent: Boolean? = null,
        name: String? = null,
        nameRegex: String? = null,
        type: String? = null,
    ): GetImageResult {
        val argument = GetImagePlainArgs(
            arn = arn,
            mostRecent = mostRecent,
            name = name,
            nameRegex = nameRegex,
            type = type,
        )
        return toKotlin(getImagePlain(argument.toJava()).await())
    }

    /**
     * @see [getImage].
     * @param argument Builder for [com&#46;pulumi&#46;aws&#46;appstream&#46;kotlin&#46;inputs&#46;GetImagePlainArgs].
     * @return A collection of values returned by getImage.
     */
    public suspend fun getImage(argument: suspend GetImagePlainArgsBuilder.() -> Unit): GetImageResult {
        val builder = GetImagePlainArgsBuilder()
        builder.argument()
        val builtArgument = builder.build()
        return toKotlin(getImagePlain(builtArgument.toJava()).await())
    }
}
