@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.kotlin.outputs.DirectoryConfigServiceAccountCredentials
import com.pulumi.aws.appstream.kotlin.outputs.DirectoryConfigServiceAccountCredentials.Companion.toKotlin
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List

/**
 * Builder for [DirectoryConfig].
 */
@PulumiTagMarker
public class DirectoryConfigResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: DirectoryConfigArgs = DirectoryConfigArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend DirectoryConfigArgsBuilder.() -> Unit) {
        val builder = DirectoryConfigArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): DirectoryConfig {
        val builtJavaResource = com.pulumi.aws.appstream.DirectoryConfig(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return DirectoryConfig(builtJavaResource)
    }
}

/**
 * Provides an AppStream Directory Config.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appstream.DirectoryConfig("example", {
 *     directoryName: "NAME OF DIRECTORY",
 *     organizationalUnitDistinguishedNames: ["DISTINGUISHED NAME"],
 *     serviceAccountCredentials: {
 *         accountName: "NAME OF ACCOUNT",
 *         accountPassword: "PASSWORD OF ACCOUNT",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appstream.DirectoryConfig("example",
 *     directory_name="NAME OF DIRECTORY",
 *     organizational_unit_distinguished_names=["DISTINGUISHED NAME"],
 *     service_account_credentials={
 *         "account_name": "NAME OF ACCOUNT",
 *         "account_password": "PASSWORD OF ACCOUNT",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppStream.DirectoryConfig("example", new()
 *     {
 *         DirectoryName = "NAME OF DIRECTORY",
 *         OrganizationalUnitDistinguishedNames = new[]
 *         {
 *             "DISTINGUISHED NAME",
 *         },
 *         ServiceAccountCredentials = new Aws.AppStream.Inputs.DirectoryConfigServiceAccountCredentialsArgs
 *         {
 *             AccountName = "NAME OF ACCOUNT",
 *             AccountPassword = "PASSWORD OF ACCOUNT",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewDirectoryConfig(ctx, "example", &appstream.DirectoryConfigArgs{
 * 			DirectoryName: pulumi.String("NAME OF DIRECTORY"),
 * 			OrganizationalUnitDistinguishedNames: pulumi.StringArray{
 * 				pulumi.String("DISTINGUISHED NAME"),
 * 			},
 * 			ServiceAccountCredentials: &appstream.DirectoryConfigServiceAccountCredentialsArgs{
 * 				AccountName:     pulumi.String("NAME OF ACCOUNT"),
 * 				AccountPassword: pulumi.String("PASSWORD OF ACCOUNT"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.DirectoryConfig;
 * import com.pulumi.aws.appstream.DirectoryConfigArgs;
 * import com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DirectoryConfig("example", DirectoryConfigArgs.builder()
 *             .directoryName("NAME OF DIRECTORY")
 *             .organizationalUnitDistinguishedNames("DISTINGUISHED NAME")
 *             .serviceAccountCredentials(DirectoryConfigServiceAccountCredentialsArgs.builder()
 *                 .accountName("NAME OF ACCOUNT")
 *                 .accountPassword("PASSWORD OF ACCOUNT")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appstream:DirectoryConfig
 *     properties:
 *       directoryName: NAME OF DIRECTORY
 *       organizationalUnitDistinguishedNames:
 *         - DISTINGUISHED NAME
 *       serviceAccountCredentials:
 *         accountName: NAME OF ACCOUNT
 *         accountPassword: PASSWORD OF ACCOUNT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_directory_config` using the id. For example:
 * ```sh
 * $ pulumi import aws:appstream/directoryConfig:DirectoryConfig example directoryNameExample
 * ```
 */
public class DirectoryConfig internal constructor(
    override val javaResource: com.pulumi.aws.appstream.DirectoryConfig,
) : KotlinCustomResource(javaResource, DirectoryConfigMapper) {
    /**
     * Date and time, in UTC and extended RFC 3339 format, when the directory config was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Fully qualified name of the directory.
     */
    public val directoryName: Output<String>
        get() = javaResource.directoryName().applyValue({ args0 -> args0 })

    /**
     * Distinguished names of the organizational units for computer accounts.
     */
    public val organizationalUnitDistinguishedNames: Output<List<String>>
        get() = javaResource.organizationalUnitDistinguishedNames().applyValue({ args0 ->
            args0.map({ args0 -> args0 })
        })

    /**
     * Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    public val serviceAccountCredentials: Output<DirectoryConfigServiceAccountCredentials>
        get() = javaResource.serviceAccountCredentials().applyValue({ args0 ->
            args0.let({ args0 ->
                toKotlin(args0)
            })
        })
}

public object DirectoryConfigMapper : ResourceMapper<DirectoryConfig> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appstream.DirectoryConfig::class == javaResource::class

    override fun map(javaResource: Resource): DirectoryConfig = DirectoryConfig(
        javaResource as
            com.pulumi.aws.appstream.DirectoryConfig,
    )
}

/**
 * @see [DirectoryConfig].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [DirectoryConfig].
 */
public suspend fun directoryConfig(
    name: String,
    block: suspend DirectoryConfigResourceBuilder.() -> Unit,
): DirectoryConfig {
    val builder = DirectoryConfigResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [DirectoryConfig].
 * @param name The _unique_ name of the resulting resource.
 */
public fun directoryConfig(name: String): DirectoryConfig {
    val builder = DirectoryConfigResourceBuilder()
    builder.name(name)
    return builder.build()
}
