@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.DirectoryConfigArgs.builder
import com.pulumi.aws.appstream.kotlin.inputs.DirectoryConfigServiceAccountCredentialsArgs
import com.pulumi.aws.appstream.kotlin.inputs.DirectoryConfigServiceAccountCredentialsArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 * Provides an AppStream Directory Config.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appstream.DirectoryConfig("example", {
 *     directoryName: "NAME OF DIRECTORY",
 *     organizationalUnitDistinguishedNames: ["DISTINGUISHED NAME"],
 *     serviceAccountCredentials: {
 *         accountName: "NAME OF ACCOUNT",
 *         accountPassword: "PASSWORD OF ACCOUNT",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appstream.DirectoryConfig("example",
 *     directory_name="NAME OF DIRECTORY",
 *     organizational_unit_distinguished_names=["DISTINGUISHED NAME"],
 *     service_account_credentials={
 *         "account_name": "NAME OF ACCOUNT",
 *         "account_password": "PASSWORD OF ACCOUNT",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppStream.DirectoryConfig("example", new()
 *     {
 *         DirectoryName = "NAME OF DIRECTORY",
 *         OrganizationalUnitDistinguishedNames = new[]
 *         {
 *             "DISTINGUISHED NAME",
 *         },
 *         ServiceAccountCredentials = new Aws.AppStream.Inputs.DirectoryConfigServiceAccountCredentialsArgs
 *         {
 *             AccountName = "NAME OF ACCOUNT",
 *             AccountPassword = "PASSWORD OF ACCOUNT",
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewDirectoryConfig(ctx, "example", &appstream.DirectoryConfigArgs{
 * 			DirectoryName: pulumi.String("NAME OF DIRECTORY"),
 * 			OrganizationalUnitDistinguishedNames: pulumi.StringArray{
 * 				pulumi.String("DISTINGUISHED NAME"),
 * 			},
 * 			ServiceAccountCredentials: &appstream.DirectoryConfigServiceAccountCredentialsArgs{
 * 				AccountName:     pulumi.String("NAME OF ACCOUNT"),
 * 				AccountPassword: pulumi.String("PASSWORD OF ACCOUNT"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.DirectoryConfig;
 * import com.pulumi.aws.appstream.DirectoryConfigArgs;
 * import com.pulumi.aws.appstream.inputs.DirectoryConfigServiceAccountCredentialsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new DirectoryConfig("example", DirectoryConfigArgs.builder()
 *             .directoryName("NAME OF DIRECTORY")
 *             .organizationalUnitDistinguishedNames("DISTINGUISHED NAME")
 *             .serviceAccountCredentials(DirectoryConfigServiceAccountCredentialsArgs.builder()
 *                 .accountName("NAME OF ACCOUNT")
 *                 .accountPassword("PASSWORD OF ACCOUNT")
 *                 .build())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appstream:DirectoryConfig
 *     properties:
 *       directoryName: NAME OF DIRECTORY
 *       organizationalUnitDistinguishedNames:
 *         - DISTINGUISHED NAME
 *       serviceAccountCredentials:
 *         accountName: NAME OF ACCOUNT
 *         accountPassword: PASSWORD OF ACCOUNT
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_directory_config` using the id. For example:
 * ```sh
 * $ pulumi import aws:appstream/directoryConfig:DirectoryConfig example directoryNameExample
 * ```
 * @property directoryName Fully qualified name of the directory.
 * @property organizationalUnitDistinguishedNames Distinguished names of the organizational units for computer accounts.
 * @property serviceAccountCredentials Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
 */
public data class DirectoryConfigArgs(
    public val directoryName: Output<String>? = null,
    public val organizationalUnitDistinguishedNames: Output<List<String>>? = null,
    public val serviceAccountCredentials: Output<DirectoryConfigServiceAccountCredentialsArgs>? =
        null,
) : ConvertibleToJava<com.pulumi.aws.appstream.DirectoryConfigArgs> {
    override fun toJava(): com.pulumi.aws.appstream.DirectoryConfigArgs =
        com.pulumi.aws.appstream.DirectoryConfigArgs.builder()
            .directoryName(directoryName?.applyValue({ args0 -> args0 }))
            .organizationalUnitDistinguishedNames(
                organizationalUnitDistinguishedNames?.applyValue({ args0 ->
                    args0.map({ args0 -> args0 })
                }),
            )
            .serviceAccountCredentials(
                serviceAccountCredentials?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            ).build()
}

/**
 * Builder for [DirectoryConfigArgs].
 */
@PulumiTagMarker
public class DirectoryConfigArgsBuilder internal constructor() {
    private var directoryName: Output<String>? = null

    private var organizationalUnitDistinguishedNames: Output<List<String>>? = null

    private var serviceAccountCredentials: Output<DirectoryConfigServiceAccountCredentialsArgs>? =
        null

    /**
     * @param value Fully qualified name of the directory.
     */
    @JvmName("ubtraoscngiaxovk")
    public suspend fun directoryName(`value`: Output<String>) {
        this.directoryName = value
    }

    /**
     * @param value Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("hhkmucscltquxuda")
    public suspend fun organizationalUnitDistinguishedNames(`value`: Output<List<String>>) {
        this.organizationalUnitDistinguishedNames = value
    }

    @JvmName("yhloskubhmssheno")
    public suspend fun organizationalUnitDistinguishedNames(vararg values: Output<String>) {
        this.organizationalUnitDistinguishedNames = Output.all(values.asList())
    }

    /**
     * @param values Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("etxooyhvvdgroyen")
    public suspend fun organizationalUnitDistinguishedNames(values: List<Output<String>>) {
        this.organizationalUnitDistinguishedNames = Output.all(values)
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    @JvmName("yatwhhidvdougahw")
    public suspend fun serviceAccountCredentials(`value`: Output<DirectoryConfigServiceAccountCredentialsArgs>) {
        this.serviceAccountCredentials = value
    }

    /**
     * @param value Fully qualified name of the directory.
     */
    @JvmName("utwyqvlgowvtvbui")
    public suspend fun directoryName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.directoryName = mapped
    }

    /**
     * @param value Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("saaghtwbitbsxhlh")
    public suspend fun organizationalUnitDistinguishedNames(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.organizationalUnitDistinguishedNames = mapped
    }

    /**
     * @param values Distinguished names of the organizational units for computer accounts.
     */
    @JvmName("vbmyqklyxicmliur")
    public suspend fun organizationalUnitDistinguishedNames(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.organizationalUnitDistinguishedNames = mapped
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    @JvmName("ktkfijpfypxudaln")
    public suspend fun serviceAccountCredentials(`value`: DirectoryConfigServiceAccountCredentialsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.serviceAccountCredentials = mapped
    }

    /**
     * @param argument Configuration block for the name of the directory and organizational unit (OU) to use to join the directory config to a Microsoft Active Directory domain. See `service_account_credentials` below.
     */
    @JvmName("qojxfrnpgfiqjeke")
    public suspend fun serviceAccountCredentials(argument: suspend DirectoryConfigServiceAccountCredentialsArgsBuilder.() -> Unit) {
        val toBeMapped = DirectoryConfigServiceAccountCredentialsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.serviceAccountCredentials = mapped
    }

    internal fun build(): DirectoryConfigArgs = DirectoryConfigArgs(
        directoryName = directoryName,
        organizationalUnitDistinguishedNames = organizationalUnitDistinguishedNames,
        serviceAccountCredentials = serviceAccountCredentials,
    )
}
