@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.kotlin.outputs.ImageBuilderAccessEndpoint
import com.pulumi.aws.appstream.kotlin.outputs.ImageBuilderDomainJoinInfo
import com.pulumi.aws.appstream.kotlin.outputs.ImageBuilderVpcConfig
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appstream.kotlin.outputs.ImageBuilderAccessEndpoint.Companion.toKotlin as imageBuilderAccessEndpointToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.ImageBuilderDomainJoinInfo.Companion.toKotlin as imageBuilderDomainJoinInfoToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.ImageBuilderVpcConfig.Companion.toKotlin as imageBuilderVpcConfigToKotlin

/**
 * Builder for [ImageBuilder].
 */
@PulumiTagMarker
public class ImageBuilderResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: ImageBuilderArgs = ImageBuilderArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend ImageBuilderArgsBuilder.() -> Unit) {
        val builder = ImageBuilderArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): ImageBuilder {
        val builtJavaResource = com.pulumi.aws.appstream.ImageBuilder(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return ImageBuilder(builtJavaResource)
    }
}

/**
 * Provides an AppStream image builder.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testFleet = new aws.appstream.ImageBuilder("test_fleet", {
 *     name: "Name",
 *     description: "Description of a ImageBuilder",
 *     displayName: "Display name of a ImageBuilder",
 *     enableDefaultInternetAccess: false,
 *     imageName: "AppStream-WinServer2019-10-05-2022",
 *     instanceType: "stream.standard.large",
 *     vpcConfig: {
 *         subnetIds: [example&#46;id],
 *     },
 *     tags: {
 *         Name: "Example Image Builder",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_fleet = aws.appstream.ImageBuilder("test_fleet",
 *     name="Name",
 *     description="Description of a ImageBuilder",
 *     display_name="Display name of a ImageBuilder",
 *     enable_default_internet_access=False,
 *     image_name="AppStream-WinServer2019-10-05-2022",
 *     instance_type="stream.standard.large",
 *     vpc_config={
 *         "subnet_ids": [example["id"]],
 *     },
 *     tags={
 *         "Name": "Example Image Builder",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testFleet = new Aws.AppStream.ImageBuilder("test_fleet", new()
 *     {
 *         Name = "Name",
 *         Description = "Description of a ImageBuilder",
 *         DisplayName = "Display name of a ImageBuilder",
 *         EnableDefaultInternetAccess = false,
 *         ImageName = "AppStream-WinServer2019-10-05-2022",
 *         InstanceType = "stream.standard.large",
 *         VpcConfig = new Aws.AppStream.Inputs.ImageBuilderVpcConfigArgs
 *         {
 *             SubnetIds = new[]
 *             {
 *                 example.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Image Builder" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewImageBuilder(ctx, "test_fleet", &appstream.ImageBuilderArgs{
 * 			Name:                        pulumi.String("Name"),
 * 			Description:                 pulumi.String("Description of a ImageBuilder"),
 * 			DisplayName:                 pulumi.String("Display name of a ImageBuilder"),
 * 			EnableDefaultInternetAccess: pulumi.Bool(false),
 * 			ImageName:                   pulumi.String("AppStream-WinServer2019-10-05-2022"),
 * 			InstanceType:                pulumi.String("stream.standard.large"),
 * 			VpcConfig: &appstream.ImageBuilderVpcConfigArgs{
 * 				SubnetIds: pulumi.StringArray{
 * 					example.Id,
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Image Builder"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.ImageBuilder;
 * import com.pulumi.aws.appstream.ImageBuilderArgs;
 * import com.pulumi.aws.appstream.inputs.ImageBuilderVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testFleet = new ImageBuilder("testFleet", ImageBuilderArgs.builder()
 *             .name("Name")
 *             .description("Description of a ImageBuilder")
 *             .displayName("Display name of a ImageBuilder")
 *             .enableDefaultInternetAccess(false)
 *             .imageName("AppStream-WinServer2019-10-05-2022")
 *             .instanceType("stream.standard.large")
 *             .vpcConfig(ImageBuilderVpcConfigArgs.builder()
 *                 .subnetIds(example.id())
 *                 .build())
 *             .tags(Map.of("Name", "Example Image Builder"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testFleet:
 *     type: aws:appstream:ImageBuilder
 *     name: test_fleet
 *     properties:
 *       name: Name
 *       description: Description of a ImageBuilder
 *       displayName: Display name of a ImageBuilder
 *       enableDefaultInternetAccess: false
 *       imageName: AppStream-WinServer2019-10-05-2022
 *       instanceType: stream.standard.large
 *       vpcConfig:
 *         subnetIds:
 *           - ${example.id}
 *       tags:
 *         Name: Example Image Builder
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_image_builder` using the `name`. For example:
 * ```sh
 * $ pulumi import aws:appstream/imageBuilder:ImageBuilder example imageBuilderExample
 * ```
 */
public class ImageBuilder internal constructor(
    override val javaResource: com.pulumi.aws.appstream.ImageBuilder,
) : KotlinCustomResource(javaResource, ImageBuilderMapper) {
    /**
     * Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    public val accessEndpoints: Output<List<ImageBuilderAccessEndpoint>>?
        get() = javaResource.accessEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.let({ args0 ->
                        imageBuilderAccessEndpointToKotlin(args0)
                    })
                })
            }).orElse(null)
        })

    /**
     * Version of the AppStream 2.0 agent to use for this image builder.
     */
    public val appstreamAgentVersion: Output<String>
        get() = javaResource.appstreamAgentVersion().applyValue({ args0 -> args0 })

    /**
     * ARN of the appstream image builder.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date and time, in UTC and extended RFC 3339 format, when the image builder was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Description to display.
     */
    public val description: Output<String>
        get() = javaResource.description().applyValue({ args0 -> args0 })

    /**
     * Human-readable friendly name for the AppStream image builder.
     */
    public val displayName: Output<String>
        get() = javaResource.displayName().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
     */
    public val domainJoinInfo: Output<ImageBuilderDomainJoinInfo>
        get() = javaResource.domainJoinInfo().applyValue({ args0 ->
            args0.let({ args0 ->
                imageBuilderDomainJoinInfoToKotlin(args0)
            })
        })

    /**
     * Enables or disables default internet access for the image builder.
     */
    public val enableDefaultInternetAccess: Output<Boolean>
        get() = javaResource.enableDefaultInternetAccess().applyValue({ args0 -> args0 })

    /**
     * ARN of the IAM role to apply to the image builder.
     */
    public val iamRoleArn: Output<String>
        get() = javaResource.iamRoleArn().applyValue({ args0 -> args0 })

    /**
     * ARN of the public, private, or shared image to use.
     */
    public val imageArn: Output<String>
        get() = javaResource.imageArn().applyValue({ args0 -> args0 })

    /**
     * Name of the image used to create the image builder.
     */
    public val imageName: Output<String>
        get() = javaResource.imageName().applyValue({ args0 -> args0 })

    /**
     * Instance type to use when launching the image builder.
     */
    public val instanceType: Output<String>
        get() = javaResource.instanceType().applyValue({ args0 -> args0 })

    /**
     * Unique name for the image builder.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * State of the image builder. For valid values, refer to the [AWS documentation](https://docs.aws.amazon.com/appstream2/latest/APIReference/API_ImageBuilder.html#AppStream2-Type-ImageBuilder-State).
     */
    public val state: Output<String>
        get() = javaResource.state().applyValue({ args0 -> args0 })

    /**
     * Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    /**
     * Map of tags assigned to the resource, including those inherited from the provider `default_tags` configuration block.
     */
    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for the VPC configuration for the image builder. See below.
     */
    public val vpcConfig: Output<ImageBuilderVpcConfig>
        get() = javaResource.vpcConfig().applyValue({ args0 ->
            args0.let({ args0 ->
                imageBuilderVpcConfigToKotlin(args0)
            })
        })
}

public object ImageBuilderMapper : ResourceMapper<ImageBuilder> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appstream.ImageBuilder::class == javaResource::class

    override fun map(javaResource: Resource): ImageBuilder = ImageBuilder(
        javaResource as
            com.pulumi.aws.appstream.ImageBuilder,
    )
}

/**
 * @see [ImageBuilder].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [ImageBuilder].
 */
public suspend fun imageBuilder(
    name: String,
    block: suspend ImageBuilderResourceBuilder.() -> Unit,
): ImageBuilder {
    val builder = ImageBuilderResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [ImageBuilder].
 * @param name The _unique_ name of the resulting resource.
 */
public fun imageBuilder(name: String): ImageBuilder {
    val builder = ImageBuilderResourceBuilder()
    builder.name(name)
    return builder.build()
}
