@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.ImageBuilderArgs.builder
import com.pulumi.aws.appstream.kotlin.inputs.ImageBuilderAccessEndpointArgs
import com.pulumi.aws.appstream.kotlin.inputs.ImageBuilderAccessEndpointArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.ImageBuilderDomainJoinInfoArgs
import com.pulumi.aws.appstream.kotlin.inputs.ImageBuilderDomainJoinInfoArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.ImageBuilderVpcConfigArgs
import com.pulumi.aws.appstream.kotlin.inputs.ImageBuilderVpcConfigArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Boolean
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppStream image builder.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const testFleet = new aws.appstream.ImageBuilder("test_fleet", {
 *     name: "Name",
 *     description: "Description of a ImageBuilder",
 *     displayName: "Display name of a ImageBuilder",
 *     enableDefaultInternetAccess: false,
 *     imageName: "AppStream-WinServer2019-10-05-2022",
 *     instanceType: "stream.standard.large",
 *     vpcConfig: {
 *         subnetIds: [example&#46;id],
 *     },
 *     tags: {
 *         Name: "Example Image Builder",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test_fleet = aws.appstream.ImageBuilder("test_fleet",
 *     name="Name",
 *     description="Description of a ImageBuilder",
 *     display_name="Display name of a ImageBuilder",
 *     enable_default_internet_access=False,
 *     image_name="AppStream-WinServer2019-10-05-2022",
 *     instance_type="stream.standard.large",
 *     vpc_config={
 *         "subnet_ids": [example["id"]],
 *     },
 *     tags={
 *         "Name": "Example Image Builder",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var testFleet = new Aws.AppStream.ImageBuilder("test_fleet", new()
 *     {
 *         Name = "Name",
 *         Description = "Description of a ImageBuilder",
 *         DisplayName = "Display name of a ImageBuilder",
 *         EnableDefaultInternetAccess = false,
 *         ImageName = "AppStream-WinServer2019-10-05-2022",
 *         InstanceType = "stream.standard.large",
 *         VpcConfig = new Aws.AppStream.Inputs.ImageBuilderVpcConfigArgs
 *         {
 *             SubnetIds = new[]
 *             {
 *                 example.Id,
 *             },
 *         },
 *         Tags =
 *         {
 *             { "Name", "Example Image Builder" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewImageBuilder(ctx, "test_fleet", &appstream.ImageBuilderArgs{
 * 			Name:                        pulumi.String("Name"),
 * 			Description:                 pulumi.String("Description of a ImageBuilder"),
 * 			DisplayName:                 pulumi.String("Display name of a ImageBuilder"),
 * 			EnableDefaultInternetAccess: pulumi.Bool(false),
 * 			ImageName:                   pulumi.String("AppStream-WinServer2019-10-05-2022"),
 * 			InstanceType:                pulumi.String("stream.standard.large"),
 * 			VpcConfig: &appstream.ImageBuilderVpcConfigArgs{
 * 				SubnetIds: pulumi.StringArray{
 * 					example.Id,
 * 				},
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"Name": pulumi.String("Example Image Builder"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.ImageBuilder;
 * import com.pulumi.aws.appstream.ImageBuilderArgs;
 * import com.pulumi.aws.appstream.inputs.ImageBuilderVpcConfigArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var testFleet = new ImageBuilder("testFleet", ImageBuilderArgs.builder()
 *             .name("Name")
 *             .description("Description of a ImageBuilder")
 *             .displayName("Display name of a ImageBuilder")
 *             .enableDefaultInternetAccess(false)
 *             .imageName("AppStream-WinServer2019-10-05-2022")
 *             .instanceType("stream.standard.large")
 *             .vpcConfig(ImageBuilderVpcConfigArgs.builder()
 *                 .subnetIds(example.id())
 *                 .build())
 *             .tags(Map.of("Name", "Example Image Builder"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   testFleet:
 *     type: aws:appstream:ImageBuilder
 *     name: test_fleet
 *     properties:
 *       name: Name
 *       description: Description of a ImageBuilder
 *       displayName: Display name of a ImageBuilder
 *       enableDefaultInternetAccess: false
 *       imageName: AppStream-WinServer2019-10-05-2022
 *       instanceType: stream.standard.large
 *       vpcConfig:
 *         subnetIds:
 *           - ${example.id}
 *       tags:
 *         Name: Example Image Builder
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_image_builder` using the `name`. For example:
 * ```sh
 * $ pulumi import aws:appstream/imageBuilder:ImageBuilder example imageBuilderExample
 * ```
 * @property accessEndpoints Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
 * @property appstreamAgentVersion Version of the AppStream 2.0 agent to use for this image builder.
 * @property description Description to display.
 * @property displayName Human-readable friendly name for the AppStream image builder.
 * @property domainJoinInfo Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
 * @property enableDefaultInternetAccess Enables or disables default internet access for the image builder.
 * @property iamRoleArn ARN of the IAM role to apply to the image builder.
 * @property imageArn ARN of the public, private, or shared image to use.
 * @property imageName Name of the image used to create the image builder.
 * @property instanceType Instance type to use when launching the image builder.
 * @property name Unique name for the image builder.
 * The following arguments are optional:
 * @property tags Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property vpcConfig Configuration block for the VPC configuration for the image builder. See below.
 */
public data class ImageBuilderArgs(
    public val accessEndpoints: Output<List<ImageBuilderAccessEndpointArgs>>? = null,
    public val appstreamAgentVersion: Output<String>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val domainJoinInfo: Output<ImageBuilderDomainJoinInfoArgs>? = null,
    public val enableDefaultInternetAccess: Output<Boolean>? = null,
    public val iamRoleArn: Output<String>? = null,
    public val imageArn: Output<String>? = null,
    public val imageName: Output<String>? = null,
    public val instanceType: Output<String>? = null,
    public val name: Output<String>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val vpcConfig: Output<ImageBuilderVpcConfigArgs>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.ImageBuilderArgs> {
    override fun toJava(): com.pulumi.aws.appstream.ImageBuilderArgs =
        com.pulumi.aws.appstream.ImageBuilderArgs.builder()
            .accessEndpoints(
                accessEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .appstreamAgentVersion(appstreamAgentVersion?.applyValue({ args0 -> args0 }))
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .domainJoinInfo(domainJoinInfo?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) }))
            .enableDefaultInternetAccess(enableDefaultInternetAccess?.applyValue({ args0 -> args0 }))
            .iamRoleArn(iamRoleArn?.applyValue({ args0 -> args0 }))
            .imageArn(imageArn?.applyValue({ args0 -> args0 }))
            .imageName(imageName?.applyValue({ args0 -> args0 }))
            .instanceType(instanceType?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .vpcConfig(vpcConfig?.applyValue({ args0 -> args0.let({ args0 -> args0.toJava() }) })).build()
}

/**
 * Builder for [ImageBuilderArgs].
 */
@PulumiTagMarker
public class ImageBuilderArgsBuilder internal constructor() {
    private var accessEndpoints: Output<List<ImageBuilderAccessEndpointArgs>>? = null

    private var appstreamAgentVersion: Output<String>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var domainJoinInfo: Output<ImageBuilderDomainJoinInfoArgs>? = null

    private var enableDefaultInternetAccess: Output<Boolean>? = null

    private var iamRoleArn: Output<String>? = null

    private var imageArn: Output<String>? = null

    private var imageName: Output<String>? = null

    private var instanceType: Output<String>? = null

    private var name: Output<String>? = null

    private var tags: Output<Map<String, String>>? = null

    private var vpcConfig: Output<ImageBuilderVpcConfigArgs>? = null

    /**
     * @param value Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("mhlbsoxudcajrunn")
    public suspend fun accessEndpoints(`value`: Output<List<ImageBuilderAccessEndpointArgs>>) {
        this.accessEndpoints = value
    }

    @JvmName("nmvthaxlyvdxwpoi")
    public suspend fun accessEndpoints(vararg values: Output<ImageBuilderAccessEndpointArgs>) {
        this.accessEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("nksddkilcdcirxuy")
    public suspend fun accessEndpoints(values: List<Output<ImageBuilderAccessEndpointArgs>>) {
        this.accessEndpoints = Output.all(values)
    }

    /**
     * @param value Version of the AppStream 2.0 agent to use for this image builder.
     */
    @JvmName("bnoanycvyynnxpwo")
    public suspend fun appstreamAgentVersion(`value`: Output<String>) {
        this.appstreamAgentVersion = value
    }

    /**
     * @param value Description to display.
     */
    @JvmName("wtrvfsqtdeotwtwn")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Human-readable friendly name for the AppStream image builder.
     */
    @JvmName("dxxhaoiydceyunvv")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
     */
    @JvmName("jdsiabdusdtroicd")
    public suspend fun domainJoinInfo(`value`: Output<ImageBuilderDomainJoinInfoArgs>) {
        this.domainJoinInfo = value
    }

    /**
     * @param value Enables or disables default internet access for the image builder.
     */
    @JvmName("nxfbmmtctrudaqvg")
    public suspend fun enableDefaultInternetAccess(`value`: Output<Boolean>) {
        this.enableDefaultInternetAccess = value
    }

    /**
     * @param value ARN of the IAM role to apply to the image builder.
     */
    @JvmName("rkcehoqdpnwcvdel")
    public suspend fun iamRoleArn(`value`: Output<String>) {
        this.iamRoleArn = value
    }

    /**
     * @param value ARN of the public, private, or shared image to use.
     */
    @JvmName("wkgolxyrdltiwqsh")
    public suspend fun imageArn(`value`: Output<String>) {
        this.imageArn = value
    }

    /**
     * @param value Name of the image used to create the image builder.
     */
    @JvmName("tvevduftdngkljwh")
    public suspend fun imageName(`value`: Output<String>) {
        this.imageName = value
    }

    /**
     * @param value Instance type to use when launching the image builder.
     */
    @JvmName("odchjxieelphcbai")
    public suspend fun instanceType(`value`: Output<String>) {
        this.instanceType = value
    }

    /**
     * @param value Unique name for the image builder.
     * The following arguments are optional:
     */
    @JvmName("qnscjlhcrvrcytqe")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("qaboxyqrrnyhhiho")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the VPC configuration for the image builder. See below.
     */
    @JvmName("sdttckomlkffcaxr")
    public suspend fun vpcConfig(`value`: Output<ImageBuilderVpcConfigArgs>) {
        this.vpcConfig = value
    }

    /**
     * @param value Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("lhdlsrbejpbtslef")
    public suspend fun accessEndpoints(`value`: List<ImageBuilderAccessEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("cbkjasnfcktongem")
    public suspend fun accessEndpoints(argument: List<suspend ImageBuilderAccessEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            ImageBuilderAccessEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("qnogoxtkuvlhhmgr")
    public suspend fun accessEndpoints(vararg argument: suspend ImageBuilderAccessEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            ImageBuilderAccessEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("jvvnpsrmotdrijqt")
    public suspend fun accessEndpoints(argument: suspend ImageBuilderAccessEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(
            ImageBuilderAccessEndpointArgsBuilder().applySuspend {
                argument()
            }.build(),
        )
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param values Set of interface VPC endpoint (interface endpoint) objects. Maximum of 4. See below.
     */
    @JvmName("cklraetegnutdked")
    public suspend fun accessEndpoints(vararg values: ImageBuilderAccessEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessEndpoints = mapped
    }

    /**
     * @param value Version of the AppStream 2.0 agent to use for this image builder.
     */
    @JvmName("tontvddicbxhamip")
    public suspend fun appstreamAgentVersion(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.appstreamAgentVersion = mapped
    }

    /**
     * @param value Description to display.
     */
    @JvmName("wqnhacsibepqbmwa")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Human-readable friendly name for the AppStream image builder.
     */
    @JvmName("dgelvtofjfqxcbxs")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
     */
    @JvmName("tdwebutymbwtpiym")
    public suspend fun domainJoinInfo(`value`: ImageBuilderDomainJoinInfoArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.domainJoinInfo = mapped
    }

    /**
     * @param argument Configuration block for the name of the directory and organizational unit (OU) to use to join the image builder to a Microsoft Active Directory domain. See below.
     */
    @JvmName("oaoyjcdbvdrqxwbj")
    public suspend fun domainJoinInfo(argument: suspend ImageBuilderDomainJoinInfoArgsBuilder.() -> Unit) {
        val toBeMapped = ImageBuilderDomainJoinInfoArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.domainJoinInfo = mapped
    }

    /**
     * @param value Enables or disables default internet access for the image builder.
     */
    @JvmName("xvprjxgdkotqyjdc")
    public suspend fun enableDefaultInternetAccess(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enableDefaultInternetAccess = mapped
    }

    /**
     * @param value ARN of the IAM role to apply to the image builder.
     */
    @JvmName("mgmuvcxqijmflmsh")
    public suspend fun iamRoleArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.iamRoleArn = mapped
    }

    /**
     * @param value ARN of the public, private, or shared image to use.
     */
    @JvmName("muissvcqbogljnru")
    public suspend fun imageArn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageArn = mapped
    }

    /**
     * @param value Name of the image used to create the image builder.
     */
    @JvmName("mbpxbdyekjbiiqrw")
    public suspend fun imageName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.imageName = mapped
    }

    /**
     * @param value Instance type to use when launching the image builder.
     */
    @JvmName("pbpsuhcxlrycluqv")
    public suspend fun instanceType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.instanceType = mapped
    }

    /**
     * @param value Unique name for the image builder.
     * The following arguments are optional:
     */
    @JvmName("drxcfhktacwprtfa")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("xarxetimisofbsuj")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Map of tags to assign to the instance. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("wtoqftfrvajjvahu")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for the VPC configuration for the image builder. See below.
     */
    @JvmName("wmakxqdaxkhbltna")
    public suspend fun vpcConfig(`value`: ImageBuilderVpcConfigArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.vpcConfig = mapped
    }

    /**
     * @param argument Configuration block for the VPC configuration for the image builder. See below.
     */
    @JvmName("bdvhsjnvjstcteov")
    public suspend fun vpcConfig(argument: suspend ImageBuilderVpcConfigArgsBuilder.() -> Unit) {
        val toBeMapped = ImageBuilderVpcConfigArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.vpcConfig = mapped
    }

    internal fun build(): ImageBuilderArgs = ImageBuilderArgs(
        accessEndpoints = accessEndpoints,
        appstreamAgentVersion = appstreamAgentVersion,
        description = description,
        displayName = displayName,
        domainJoinInfo = domainJoinInfo,
        enableDefaultInternetAccess = enableDefaultInternetAccess,
        iamRoleArn = iamRoleArn,
        imageArn = imageArn,
        imageName = imageName,
        instanceType = instanceType,
        name = name,
        tags = tags,
        vpcConfig = vpcConfig,
    )
}
