@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.kotlin.outputs.StackAccessEndpoint
import com.pulumi.aws.appstream.kotlin.outputs.StackApplicationSettings
import com.pulumi.aws.appstream.kotlin.outputs.StackStorageConnector
import com.pulumi.aws.appstream.kotlin.outputs.StackStreamingExperienceSettings
import com.pulumi.aws.appstream.kotlin.outputs.StackUserSetting
import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.Deprecated
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import com.pulumi.aws.appstream.kotlin.outputs.StackAccessEndpoint.Companion.toKotlin as stackAccessEndpointToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.StackApplicationSettings.Companion.toKotlin as stackApplicationSettingsToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.StackStorageConnector.Companion.toKotlin as stackStorageConnectorToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.StackStreamingExperienceSettings.Companion.toKotlin as stackStreamingExperienceSettingsToKotlin
import com.pulumi.aws.appstream.kotlin.outputs.StackUserSetting.Companion.toKotlin as stackUserSettingToKotlin

/**
 * Builder for [Stack].
 */
@PulumiTagMarker
public class StackResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: StackArgs = StackArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend StackArgsBuilder.() -> Unit) {
        val builder = StackArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): Stack {
        val builtJavaResource = com.pulumi.aws.appstream.Stack(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return Stack(builtJavaResource)
    }
}

/**
 * Provides an AppStream stack.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appstream.Stack("example", {
 *     name: "stack name",
 *     description: "stack description",
 *     displayName: "stack display name",
 *     feedbackUrl: "http://your-domain/feedback",
 *     redirectUrl: "http://your-domain/redirect",
 *     storageConnectors: [{
 *         connectorType: "HOMEFOLDERS",
 *     }],
 *     userSettings: [
 *         {
 *             action: "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "DOMAIN_PASSWORD_SIGNIN",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "DOMAIN_SMART_CARD_SIGNIN",
 *             permission: "DISABLED",
 *         },
 *         {
 *             action: "FILE_DOWNLOAD",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "FILE_UPLOAD",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "PRINTING_TO_LOCAL_DEVICE",
 *             permission: "ENABLED",
 *         },
 *     ],
 *     applicationSettings: {
 *         enabled: true,
 *         settingsGroup: "SettingsGroup",
 *     },
 *     tags: {
 *         TagName: "TagValue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appstream.Stack("example",
 *     name="stack name",
 *     description="stack description",
 *     display_name="stack display name",
 *     feedback_url="http://your-domain/feedback",
 *     redirect_url="http://your-domain/redirect",
 *     storage_connectors=[{
 *         "connector_type": "HOMEFOLDERS",
 *     }],
 *     user_settings=[
 *         {
 *             "action": "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "DOMAIN_PASSWORD_SIGNIN",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "DOMAIN_SMART_CARD_SIGNIN",
 *             "permission": "DISABLED",
 *         },
 *         {
 *             "action": "FILE_DOWNLOAD",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "FILE_UPLOAD",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "PRINTING_TO_LOCAL_DEVICE",
 *             "permission": "ENABLED",
 *         },
 *     ],
 *     application_settings={
 *         "enabled": True,
 *         "settings_group": "SettingsGroup",
 *     },
 *     tags={
 *         "TagName": "TagValue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppStream.Stack("example", new()
 *     {
 *         Name = "stack name",
 *         Description = "stack description",
 *         DisplayName = "stack display name",
 *         FeedbackUrl = "http://your-domain/feedback",
 *         RedirectUrl = "http://your-domain/redirect",
 *         StorageConnectors = new[]
 *         {
 *             new Aws.AppStream.Inputs.StackStorageConnectorArgs
 *             {
 *                 ConnectorType = "HOMEFOLDERS",
 *             },
 *         },
 *         UserSettings = new[]
 *         {
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "DOMAIN_PASSWORD_SIGNIN",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "DOMAIN_SMART_CARD_SIGNIN",
 *                 Permission = "DISABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "FILE_DOWNLOAD",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "FILE_UPLOAD",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "PRINTING_TO_LOCAL_DEVICE",
 *                 Permission = "ENABLED",
 *             },
 *         },
 *         ApplicationSettings = new Aws.AppStream.Inputs.StackApplicationSettingsArgs
 *         {
 *             Enabled = true,
 *             SettingsGroup = "SettingsGroup",
 *         },
 *         Tags =
 *         {
 *             { "TagName", "TagValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewStack(ctx, "example", &appstream.StackArgs{
 * 			Name:        pulumi.String("stack name"),
 * 			Description: pulumi.String("stack description"),
 * 			DisplayName: pulumi.String("stack display name"),
 * 			FeedbackUrl: pulumi.String("http://your-domain/feedback"),
 * 			RedirectUrl: pulumi.String("http://your-domain/redirect"),
 * 			StorageConnectors: appstream.StackStorageConnectorArray{
 * 				&appstream.StackStorageConnectorArgs{
 * 					ConnectorType: pulumi.String("HOMEFOLDERS"),
 * 				},
 * 			},
 * 			UserSettings: appstream.StackUserSettingArray{
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("CLIPBOARD_COPY_FROM_LOCAL_DEVICE"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("CLIPBOARD_COPY_TO_LOCAL_DEVICE"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("DOMAIN_PASSWORD_SIGNIN"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("DOMAIN_SMART_CARD_SIGNIN"),
 * 					Permission: pulumi.String("DISABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("FILE_DOWNLOAD"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("FILE_UPLOAD"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("PRINTING_TO_LOCAL_DEVICE"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 			},
 * 			ApplicationSettings: &appstream.StackApplicationSettingsArgs{
 * 				Enabled:       pulumi.Bool(true),
 * 				SettingsGroup: pulumi.String("SettingsGroup"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"TagName": pulumi.String("TagValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.StackArgs;
 * import com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs;
 * import com.pulumi.aws.appstream.inputs.StackUserSettingArgs;
 * import com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stack("example", StackArgs.builder()
 *             .name("stack name")
 *             .description("stack description")
 *             .displayName("stack display name")
 *             .feedbackUrl("http://your-domain/feedback")
 *             .redirectUrl("http://your-domain/redirect")
 *             .storageConnectors(StackStorageConnectorArgs.builder()
 *                 .connectorType("HOMEFOLDERS")
 *                 .build())
 *             .userSettings(
 *                 StackUserSettingArgs.builder()
 *                     .action("CLIPBOARD_COPY_FROM_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("CLIPBOARD_COPY_TO_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("DOMAIN_PASSWORD_SIGNIN")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("DOMAIN_SMART_CARD_SIGNIN")
 *                     .permission("DISABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("FILE_DOWNLOAD")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("FILE_UPLOAD")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("PRINTING_TO_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build())
 *             .applicationSettings(StackApplicationSettingsArgs.builder()
 *                 .enabled(true)
 *                 .settingsGroup("SettingsGroup")
 *                 .build())
 *             .tags(Map.of("TagName", "TagValue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appstream:Stack
 *     properties:
 *       name: stack name
 *       description: stack description
 *       displayName: stack display name
 *       feedbackUrl: http://your-domain/feedback
 *       redirectUrl: http://your-domain/redirect
 *       storageConnectors:
 *         - connectorType: HOMEFOLDERS
 *       userSettings:
 *         - action: CLIPBOARD_COPY_FROM_LOCAL_DEVICE
 *           permission: ENABLED
 *         - action: CLIPBOARD_COPY_TO_LOCAL_DEVICE
 *           permission: ENABLED
 *         - action: DOMAIN_PASSWORD_SIGNIN
 *           permission: ENABLED
 *         - action: DOMAIN_SMART_CARD_SIGNIN
 *           permission: DISABLED
 *         - action: FILE_DOWNLOAD
 *           permission: ENABLED
 *         - action: FILE_UPLOAD
 *           permission: ENABLED
 *         - action: PRINTING_TO_LOCAL_DEVICE
 *           permission: ENABLED
 *       applicationSettings:
 *         enabled: true
 *         settingsGroup: SettingsGroup
 *       tags:
 *         TagName: TagValue
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_stack` using the id. For example:
 * ```sh
 * $ pulumi import aws:appstream/stack:Stack example stackID
 * ```
 */
public class Stack internal constructor(
    override val javaResource: com.pulumi.aws.appstream.Stack,
) : KotlinCustomResource(javaResource, StackMapper) {
    /**
     * Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    public val accessEndpoints: Output<List<StackAccessEndpoint>>
        get() = javaResource.accessEndpoints().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackAccessEndpointToKotlin(args0) })
            })
        })

    /**
     * Settings for application settings persistence.
     * See `application_settings` below.
     */
    public val applicationSettings: Output<StackApplicationSettings>
        get() = javaResource.applicationSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                stackApplicationSettingsToKotlin(args0)
            })
        })

    /**
     * ARN of the appstream stack.
     */
    public val arn: Output<String>
        get() = javaResource.arn().applyValue({ args0 -> args0 })

    /**
     * Date and time, in UTC and extended RFC 3339 format, when the stack was created.
     */
    public val createdTime: Output<String>
        get() = javaResource.createdTime().applyValue({ args0 -> args0 })

    /**
     * Description for the AppStream stack.
     */
    public val description: Output<String>?
        get() = javaResource.description().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Stack name to display.
     */
    public val displayName: Output<String>?
        get() = javaResource.displayName().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    public val embedHostDomains: Output<List<String>>
        get() = javaResource.embedHostDomains().applyValue({ args0 -> args0.map({ args0 -> args0 }) })

    /**
     * URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
     */
    public val feedbackUrl: Output<String>
        get() = javaResource.feedbackUrl().applyValue({ args0 -> args0 })

    /**
     * Unique name for the AppStream stack.
     * The following arguments are optional:
     */
    public val name: Output<String>
        get() = javaResource.name().applyValue({ args0 -> args0 })

    /**
     * URL that users are redirected to after their streaming session ends.
     */
    public val redirectUrl: Output<String>
        get() = javaResource.redirectUrl().applyValue({ args0 -> args0 })

    /**
     * Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    public val storageConnectors: Output<List<StackStorageConnector>>
        get() = javaResource.storageConnectors().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 -> stackStorageConnectorToKotlin(args0) })
            })
        })

    /**
     * The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    public val streamingExperienceSettings: Output<StackStreamingExperienceSettings>
        get() = javaResource.streamingExperienceSettings().applyValue({ args0 ->
            args0.let({ args0 ->
                stackStreamingExperienceSettingsToKotlin(args0)
            })
        })

    /**
     * Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    public val tags: Output<Map<String, String>>?
        get() = javaResource.tags().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.map({ args0 ->
                    args0.key.to(args0.value)
                }).toMap()
            }).orElse(null)
        })

    @Deprecated(
        message = """
  Please use `tags` instead.
  """,
    )
    public val tagsAll: Output<Map<String, String>>
        get() = javaResource.tagsAll().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.key.to(args0.value)
            }).toMap()
        })

    /**
     * Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    public val userSettings: Output<List<StackUserSetting>>
        get() = javaResource.userSettings().applyValue({ args0 ->
            args0.map({ args0 ->
                args0.let({ args0 ->
                    stackUserSettingToKotlin(args0)
                })
            })
        })
}

public object StackMapper : ResourceMapper<Stack> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appstream.Stack::class == javaResource::class

    override fun map(javaResource: Resource): Stack = Stack(
        javaResource as
            com.pulumi.aws.appstream.Stack,
    )
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [Stack].
 */
public suspend fun stack(name: String, block: suspend StackResourceBuilder.() -> Unit): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [Stack].
 * @param name The _unique_ name of the resulting resource.
 */
public fun stack(name: String): Stack {
    val builder = StackResourceBuilder()
    builder.name(name)
    return builder.build()
}
