@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.StackArgs.builder
import com.pulumi.aws.appstream.kotlin.inputs.StackAccessEndpointArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackAccessEndpointArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackApplicationSettingsArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackApplicationSettingsArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackStorageConnectorArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackStorageConnectorArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackStreamingExperienceSettingsArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackStreamingExperienceSettingsArgsBuilder
import com.pulumi.aws.appstream.kotlin.inputs.StackUserSettingArgs
import com.pulumi.aws.appstream.kotlin.inputs.StackUserSettingArgsBuilder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.applySuspend
import kotlin.Pair
import kotlin.String
import kotlin.Suppress
import kotlin.Unit
import kotlin.collections.List
import kotlin.collections.Map
import kotlin.jvm.JvmName

/**
 * Provides an AppStream stack.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appstream.Stack("example", {
 *     name: "stack name",
 *     description: "stack description",
 *     displayName: "stack display name",
 *     feedbackUrl: "http://your-domain/feedback",
 *     redirectUrl: "http://your-domain/redirect",
 *     storageConnectors: [{
 *         connectorType: "HOMEFOLDERS",
 *     }],
 *     userSettings: [
 *         {
 *             action: "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "DOMAIN_PASSWORD_SIGNIN",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "DOMAIN_SMART_CARD_SIGNIN",
 *             permission: "DISABLED",
 *         },
 *         {
 *             action: "FILE_DOWNLOAD",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "FILE_UPLOAD",
 *             permission: "ENABLED",
 *         },
 *         {
 *             action: "PRINTING_TO_LOCAL_DEVICE",
 *             permission: "ENABLED",
 *         },
 *     ],
 *     applicationSettings: {
 *         enabled: true,
 *         settingsGroup: "SettingsGroup",
 *     },
 *     tags: {
 *         TagName: "TagValue",
 *     },
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appstream.Stack("example",
 *     name="stack name",
 *     description="stack description",
 *     display_name="stack display name",
 *     feedback_url="http://your-domain/feedback",
 *     redirect_url="http://your-domain/redirect",
 *     storage_connectors=[{
 *         "connector_type": "HOMEFOLDERS",
 *     }],
 *     user_settings=[
 *         {
 *             "action": "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "DOMAIN_PASSWORD_SIGNIN",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "DOMAIN_SMART_CARD_SIGNIN",
 *             "permission": "DISABLED",
 *         },
 *         {
 *             "action": "FILE_DOWNLOAD",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "FILE_UPLOAD",
 *             "permission": "ENABLED",
 *         },
 *         {
 *             "action": "PRINTING_TO_LOCAL_DEVICE",
 *             "permission": "ENABLED",
 *         },
 *     ],
 *     application_settings={
 *         "enabled": True,
 *         "settings_group": "SettingsGroup",
 *     },
 *     tags={
 *         "TagName": "TagValue",
 *     })
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppStream.Stack("example", new()
 *     {
 *         Name = "stack name",
 *         Description = "stack description",
 *         DisplayName = "stack display name",
 *         FeedbackUrl = "http://your-domain/feedback",
 *         RedirectUrl = "http://your-domain/redirect",
 *         StorageConnectors = new[]
 *         {
 *             new Aws.AppStream.Inputs.StackStorageConnectorArgs
 *             {
 *                 ConnectorType = "HOMEFOLDERS",
 *             },
 *         },
 *         UserSettings = new[]
 *         {
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "CLIPBOARD_COPY_FROM_LOCAL_DEVICE",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "CLIPBOARD_COPY_TO_LOCAL_DEVICE",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "DOMAIN_PASSWORD_SIGNIN",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "DOMAIN_SMART_CARD_SIGNIN",
 *                 Permission = "DISABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "FILE_DOWNLOAD",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "FILE_UPLOAD",
 *                 Permission = "ENABLED",
 *             },
 *             new Aws.AppStream.Inputs.StackUserSettingArgs
 *             {
 *                 Action = "PRINTING_TO_LOCAL_DEVICE",
 *                 Permission = "ENABLED",
 *             },
 *         },
 *         ApplicationSettings = new Aws.AppStream.Inputs.StackApplicationSettingsArgs
 *         {
 *             Enabled = true,
 *             SettingsGroup = "SettingsGroup",
 *         },
 *         Tags =
 *         {
 *             { "TagName", "TagValue" },
 *         },
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewStack(ctx, "example", &appstream.StackArgs{
 * 			Name:        pulumi.String("stack name"),
 * 			Description: pulumi.String("stack description"),
 * 			DisplayName: pulumi.String("stack display name"),
 * 			FeedbackUrl: pulumi.String("http://your-domain/feedback"),
 * 			RedirectUrl: pulumi.String("http://your-domain/redirect"),
 * 			StorageConnectors: appstream.StackStorageConnectorArray{
 * 				&appstream.StackStorageConnectorArgs{
 * 					ConnectorType: pulumi.String("HOMEFOLDERS"),
 * 				},
 * 			},
 * 			UserSettings: appstream.StackUserSettingArray{
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("CLIPBOARD_COPY_FROM_LOCAL_DEVICE"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("CLIPBOARD_COPY_TO_LOCAL_DEVICE"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("DOMAIN_PASSWORD_SIGNIN"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("DOMAIN_SMART_CARD_SIGNIN"),
 * 					Permission: pulumi.String("DISABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("FILE_DOWNLOAD"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("FILE_UPLOAD"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 				&appstream.StackUserSettingArgs{
 * 					Action:     pulumi.String("PRINTING_TO_LOCAL_DEVICE"),
 * 					Permission: pulumi.String("ENABLED"),
 * 				},
 * 			},
 * 			ApplicationSettings: &appstream.StackApplicationSettingsArgs{
 * 				Enabled:       pulumi.Bool(true),
 * 				SettingsGroup: pulumi.String("SettingsGroup"),
 * 			},
 * 			Tags: pulumi.StringMap{
 * 				"TagName": pulumi.String("TagValue"),
 * 			},
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.StackArgs;
 * import com.pulumi.aws.appstream.inputs.StackStorageConnectorArgs;
 * import com.pulumi.aws.appstream.inputs.StackUserSettingArgs;
 * import com.pulumi.aws.appstream.inputs.StackApplicationSettingsArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new Stack("example", StackArgs.builder()
 *             .name("stack name")
 *             .description("stack description")
 *             .displayName("stack display name")
 *             .feedbackUrl("http://your-domain/feedback")
 *             .redirectUrl("http://your-domain/redirect")
 *             .storageConnectors(StackStorageConnectorArgs.builder()
 *                 .connectorType("HOMEFOLDERS")
 *                 .build())
 *             .userSettings(
 *                 StackUserSettingArgs.builder()
 *                     .action("CLIPBOARD_COPY_FROM_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("CLIPBOARD_COPY_TO_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("DOMAIN_PASSWORD_SIGNIN")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("DOMAIN_SMART_CARD_SIGNIN")
 *                     .permission("DISABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("FILE_DOWNLOAD")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("FILE_UPLOAD")
 *                     .permission("ENABLED")
 *                     .build(),
 *                 StackUserSettingArgs.builder()
 *                     .action("PRINTING_TO_LOCAL_DEVICE")
 *                     .permission("ENABLED")
 *                     .build())
 *             .applicationSettings(StackApplicationSettingsArgs.builder()
 *                 .enabled(true)
 *                 .settingsGroup("SettingsGroup")
 *                 .build())
 *             .tags(Map.of("TagName", "TagValue"))
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appstream:Stack
 *     properties:
 *       name: stack name
 *       description: stack description
 *       displayName: stack display name
 *       feedbackUrl: http://your-domain/feedback
 *       redirectUrl: http://your-domain/redirect
 *       storageConnectors:
 *         - connectorType: HOMEFOLDERS
 *       userSettings:
 *         - action: CLIPBOARD_COPY_FROM_LOCAL_DEVICE
 *           permission: ENABLED
 *         - action: CLIPBOARD_COPY_TO_LOCAL_DEVICE
 *           permission: ENABLED
 *         - action: DOMAIN_PASSWORD_SIGNIN
 *           permission: ENABLED
 *         - action: DOMAIN_SMART_CARD_SIGNIN
 *           permission: DISABLED
 *         - action: FILE_DOWNLOAD
 *           permission: ENABLED
 *         - action: FILE_UPLOAD
 *           permission: ENABLED
 *         - action: PRINTING_TO_LOCAL_DEVICE
 *           permission: ENABLED
 *       applicationSettings:
 *         enabled: true
 *         settingsGroup: SettingsGroup
 *       tags:
 *         TagName: TagValue
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_stack` using the id. For example:
 * ```sh
 * $ pulumi import aws:appstream/stack:Stack example stackID
 * ```
 * @property accessEndpoints Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
 * See `access_endpoints` below.
 * @property applicationSettings Settings for application settings persistence.
 * See `application_settings` below.
 * @property description Description for the AppStream stack.
 * @property displayName Stack name to display.
 * @property embedHostDomains Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
 * @property feedbackUrl URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
 * @property name Unique name for the AppStream stack.
 * The following arguments are optional:
 * @property redirectUrl URL that users are redirected to after their streaming session ends.
 * @property storageConnectors Configuration block for the storage connectors to enable.
 * See `storage_connectors` below.
 * @property streamingExperienceSettings The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
 * See `streaming_experience_settings` below.
 * @property tags Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
 * @property userSettings Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
 * See `user_settings` below.
 */
public data class StackArgs(
    public val accessEndpoints: Output<List<StackAccessEndpointArgs>>? = null,
    public val applicationSettings: Output<StackApplicationSettingsArgs>? = null,
    public val description: Output<String>? = null,
    public val displayName: Output<String>? = null,
    public val embedHostDomains: Output<List<String>>? = null,
    public val feedbackUrl: Output<String>? = null,
    public val name: Output<String>? = null,
    public val redirectUrl: Output<String>? = null,
    public val storageConnectors: Output<List<StackStorageConnectorArgs>>? = null,
    public val streamingExperienceSettings: Output<StackStreamingExperienceSettingsArgs>? = null,
    public val tags: Output<Map<String, String>>? = null,
    public val userSettings: Output<List<StackUserSettingArgs>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.StackArgs> {
    override fun toJava(): com.pulumi.aws.appstream.StackArgs =
        com.pulumi.aws.appstream.StackArgs.builder()
            .accessEndpoints(
                accessEndpoints?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .applicationSettings(
                applicationSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .description(description?.applyValue({ args0 -> args0 }))
            .displayName(displayName?.applyValue({ args0 -> args0 }))
            .embedHostDomains(embedHostDomains?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .feedbackUrl(feedbackUrl?.applyValue({ args0 -> args0 }))
            .name(name?.applyValue({ args0 -> args0 }))
            .redirectUrl(redirectUrl?.applyValue({ args0 -> args0 }))
            .storageConnectors(
                storageConnectors?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            )
            .streamingExperienceSettings(
                streamingExperienceSettings?.applyValue({ args0 ->
                    args0.let({ args0 ->
                        args0.toJava()
                    })
                }),
            )
            .tags(tags?.applyValue({ args0 -> args0.map({ args0 -> args0.key.to(args0.value) }).toMap() }))
            .userSettings(
                userSettings?.applyValue({ args0 ->
                    args0.map({ args0 ->
                        args0.let({ args0 ->
                            args0.toJava()
                        })
                    })
                }),
            ).build()
}

/**
 * Builder for [StackArgs].
 */
@PulumiTagMarker
public class StackArgsBuilder internal constructor() {
    private var accessEndpoints: Output<List<StackAccessEndpointArgs>>? = null

    private var applicationSettings: Output<StackApplicationSettingsArgs>? = null

    private var description: Output<String>? = null

    private var displayName: Output<String>? = null

    private var embedHostDomains: Output<List<String>>? = null

    private var feedbackUrl: Output<String>? = null

    private var name: Output<String>? = null

    private var redirectUrl: Output<String>? = null

    private var storageConnectors: Output<List<StackStorageConnectorArgs>>? = null

    private var streamingExperienceSettings: Output<StackStreamingExperienceSettingsArgs>? = null

    private var tags: Output<Map<String, String>>? = null

    private var userSettings: Output<List<StackUserSettingArgs>>? = null

    /**
     * @param value Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("snnsqasyfqvudywm")
    public suspend fun accessEndpoints(`value`: Output<List<StackAccessEndpointArgs>>) {
        this.accessEndpoints = value
    }

    @JvmName("rainwhipxnymmihj")
    public suspend fun accessEndpoints(vararg values: Output<StackAccessEndpointArgs>) {
        this.accessEndpoints = Output.all(values.asList())
    }

    /**
     * @param values Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("wwdnysggpkgxvhxb")
    public suspend fun accessEndpoints(values: List<Output<StackAccessEndpointArgs>>) {
        this.accessEndpoints = Output.all(values)
    }

    /**
     * @param value Settings for application settings persistence.
     * See `application_settings` below.
     */
    @JvmName("yiovyjpqshgvuwnv")
    public suspend fun applicationSettings(`value`: Output<StackApplicationSettingsArgs>) {
        this.applicationSettings = value
    }

    /**
     * @param value Description for the AppStream stack.
     */
    @JvmName("hbgvfhhhkqeamlrb")
    public suspend fun description(`value`: Output<String>) {
        this.description = value
    }

    /**
     * @param value Stack name to display.
     */
    @JvmName("ahqiykjhtgvyptsa")
    public suspend fun displayName(`value`: Output<String>) {
        this.displayName = value
    }

    /**
     * @param value Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("pnbyebypofnmugwj")
    public suspend fun embedHostDomains(`value`: Output<List<String>>) {
        this.embedHostDomains = value
    }

    @JvmName("dsgbuoafewciyhgb")
    public suspend fun embedHostDomains(vararg values: Output<String>) {
        this.embedHostDomains = Output.all(values.asList())
    }

    /**
     * @param values Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("rjskqmtslpbbnslo")
    public suspend fun embedHostDomains(values: List<Output<String>>) {
        this.embedHostDomains = Output.all(values)
    }

    /**
     * @param value URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
     */
    @JvmName("asvvtumptktriscp")
    public suspend fun feedbackUrl(`value`: Output<String>) {
        this.feedbackUrl = value
    }

    /**
     * @param value Unique name for the AppStream stack.
     * The following arguments are optional:
     */
    @JvmName("xfnwdysdpvfjxybh")
    public suspend fun name(`value`: Output<String>) {
        this.name = value
    }

    /**
     * @param value URL that users are redirected to after their streaming session ends.
     */
    @JvmName("illdpaeldkroersr")
    public suspend fun redirectUrl(`value`: Output<String>) {
        this.redirectUrl = value
    }

    /**
     * @param value Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("rxbxjsxujkfkttpj")
    public suspend fun storageConnectors(`value`: Output<List<StackStorageConnectorArgs>>) {
        this.storageConnectors = value
    }

    @JvmName("hmjnnmickfqgcafw")
    public suspend fun storageConnectors(vararg values: Output<StackStorageConnectorArgs>) {
        this.storageConnectors = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("rrqrugfdvbpxghmb")
    public suspend fun storageConnectors(values: List<Output<StackStorageConnectorArgs>>) {
        this.storageConnectors = Output.all(values)
    }

    /**
     * @param value The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    @JvmName("bybcgpajuglknppk")
    public suspend fun streamingExperienceSettings(`value`: Output<StackStreamingExperienceSettingsArgs>) {
        this.streamingExperienceSettings = value
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("mpwxkeclmkwoygon")
    public suspend fun tags(`value`: Output<Map<String, String>>) {
        this.tags = value
    }

    /**
     * @param value Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("ebpaygiknnhbqjgh")
    public suspend fun userSettings(`value`: Output<List<StackUserSettingArgs>>) {
        this.userSettings = value
    }

    @JvmName("spwluywrmnyhcahm")
    public suspend fun userSettings(vararg values: Output<StackUserSettingArgs>) {
        this.userSettings = Output.all(values.asList())
    }

    /**
     * @param values Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("dpflfrgerycuqdcx")
    public suspend fun userSettings(values: List<Output<StackUserSettingArgs>>) {
        this.userSettings = Output.all(values)
    }

    /**
     * @param value Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("sqhvopyvysxflmph")
    public suspend fun accessEndpoints(`value`: List<StackAccessEndpointArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("avmngegpfgybvxtg")
    public suspend fun accessEndpoints(argument: List<suspend StackAccessEndpointArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackAccessEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("ekiatcfgnaufwtym")
    public suspend fun accessEndpoints(vararg argument: suspend StackAccessEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackAccessEndpointArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param argument Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("ssyolejwjbkngjkd")
    public suspend fun accessEndpoints(argument: suspend StackAccessEndpointArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackAccessEndpointArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.accessEndpoints = mapped
    }

    /**
     * @param values Set of configuration blocks defining the interface VPC endpoints. Users of the stack can connect to AppStream 2.0 only through the specified endpoints.
     * See `access_endpoints` below.
     */
    @JvmName("cakfqhknxyijfuej")
    public suspend fun accessEndpoints(vararg values: StackAccessEndpointArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.accessEndpoints = mapped
    }

    /**
     * @param value Settings for application settings persistence.
     * See `application_settings` below.
     */
    @JvmName("enqplylhheykweub")
    public suspend fun applicationSettings(`value`: StackApplicationSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.applicationSettings = mapped
    }

    /**
     * @param argument Settings for application settings persistence.
     * See `application_settings` below.
     */
    @JvmName("kmynjahikiipocbr")
    public suspend fun applicationSettings(argument: suspend StackApplicationSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackApplicationSettingsArgsBuilder().applySuspend { argument() }.build()
        val mapped = of(toBeMapped)
        this.applicationSettings = mapped
    }

    /**
     * @param value Description for the AppStream stack.
     */
    @JvmName("ebdlmarmwdsmlwmy")
    public suspend fun description(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.description = mapped
    }

    /**
     * @param value Stack name to display.
     */
    @JvmName("coahscorknfvlugn")
    public suspend fun displayName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.displayName = mapped
    }

    /**
     * @param value Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("qkwrqadrpanjdggk")
    public suspend fun embedHostDomains(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.embedHostDomains = mapped
    }

    /**
     * @param values Domains where AppStream 2.0 streaming sessions can be embedded in an iframe. You must approve the domains that you want to host embedded AppStream 2.0 streaming sessions.
     */
    @JvmName("argasjuwfycgaieu")
    public suspend fun embedHostDomains(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.embedHostDomains = mapped
    }

    /**
     * @param value URL that users are redirected to after they click the Send Feedback link. If no URL is specified, no Send Feedback link is displayed. .
     */
    @JvmName("tdnbjesfybwskltt")
    public suspend fun feedbackUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.feedbackUrl = mapped
    }

    /**
     * @param value Unique name for the AppStream stack.
     * The following arguments are optional:
     */
    @JvmName("cxdwyiacgagqhpoi")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.name = mapped
    }

    /**
     * @param value URL that users are redirected to after their streaming session ends.
     */
    @JvmName("uykmuhawwfmklunr")
    public suspend fun redirectUrl(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.redirectUrl = mapped
    }

    /**
     * @param value Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("xjpqnoikejviyixq")
    public suspend fun storageConnectors(`value`: List<StackStorageConnectorArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.storageConnectors = mapped
    }

    /**
     * @param argument Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("ktxgkpyjccrxdser")
    public suspend fun storageConnectors(argument: List<suspend StackStorageConnectorArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackStorageConnectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageConnectors = mapped
    }

    /**
     * @param argument Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("rlipishbtnygejyy")
    public suspend fun storageConnectors(vararg argument: suspend StackStorageConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackStorageConnectorArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.storageConnectors = mapped
    }

    /**
     * @param argument Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("ixcgrawicucbhkay")
    public suspend fun storageConnectors(argument: suspend StackStorageConnectorArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackStorageConnectorArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.storageConnectors = mapped
    }

    /**
     * @param values Configuration block for the storage connectors to enable.
     * See `storage_connectors` below.
     */
    @JvmName("bnaqtlmhjnhayupx")
    public suspend fun storageConnectors(vararg values: StackStorageConnectorArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.storageConnectors = mapped
    }

    /**
     * @param value The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    @JvmName("hvbtbeuuvascjytc")
    public suspend fun streamingExperienceSettings(`value`: StackStreamingExperienceSettingsArgs?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.streamingExperienceSettings = mapped
    }

    /**
     * @param argument The streaming protocol you want your stack to prefer. This can be UDP or TCP. Currently, UDP is only supported in the Windows native client.
     * See `streaming_experience_settings` below.
     */
    @JvmName("jogdfnfkhnqcvcjg")
    public suspend fun streamingExperienceSettings(argument: suspend StackStreamingExperienceSettingsArgsBuilder.() -> Unit) {
        val toBeMapped = StackStreamingExperienceSettingsArgsBuilder().applySuspend {
            argument()
        }.build()
        val mapped = of(toBeMapped)
        this.streamingExperienceSettings = mapped
    }

    /**
     * @param value Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("bolthiriugyxricv")
    public suspend fun tags(`value`: Map<String, String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param values Key-value mapping of resource tags. If configured with a provider `default_tags` configuration block present, tags with matching keys will overwrite those defined at the provider-level.
     */
    @JvmName("vmfnkbdqqbwjhnje")
    public fun tags(vararg values: Pair<String, String>) {
        val toBeMapped = values.toMap()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.tags = mapped
    }

    /**
     * @param value Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("qmuexyctmbncwuah")
    public suspend fun userSettings(`value`: List<StackUserSettingArgs>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userSettings = mapped
    }

    /**
     * @param argument Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("nhxhtiuqogwpbtbn")
    public suspend fun userSettings(argument: List<suspend StackUserSettingArgsBuilder.() -> Unit>) {
        val toBeMapped = argument.toList().map {
            StackUserSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    /**
     * @param argument Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("iylhjnddatbltjxy")
    public suspend fun userSettings(vararg argument: suspend StackUserSettingArgsBuilder.() -> Unit) {
        val toBeMapped = argument.toList().map {
            StackUserSettingArgsBuilder().applySuspend {
                it()
            }.build()
        }
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    /**
     * @param argument Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("jdmpvqqcaddbbfgn")
    public suspend fun userSettings(argument: suspend StackUserSettingArgsBuilder.() -> Unit) {
        val toBeMapped = listOf(StackUserSettingArgsBuilder().applySuspend { argument() }.build())
        val mapped = of(toBeMapped)
        this.userSettings = mapped
    }

    /**
     * @param values Configuration block for the actions that are enabled or disabled for users during their streaming sessions. If not provided, these settings are configured automatically by AWS. If provided, the configuration should include a block for each configurable action.
     * See `user_settings` below.
     */
    @JvmName("ytjoutpyukujdlye")
    public suspend fun userSettings(vararg values: StackUserSettingArgs) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.userSettings = mapped
    }

    internal fun build(): StackArgs = StackArgs(
        accessEndpoints = accessEndpoints,
        applicationSettings = applicationSettings,
        description = description,
        displayName = displayName,
        embedHostDomains = embedHostDomains,
        feedbackUrl = feedbackUrl,
        name = name,
        redirectUrl = redirectUrl,
        storageConnectors = storageConnectors,
        streamingExperienceSettings = streamingExperienceSettings,
        tags = tags,
        userSettings = userSettings,
    )
}
