@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.aws.appstream.UserArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * Provides an AppStream user.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const example = new aws.appstream.User("example", {
 *     authenticationType: "USERPOOL",
 *     userName: "EMAIL",
 *     firstName: "FIRST NAME",
 *     lastName: "LAST NAME",
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * example = aws.appstream.User("example",
 *     authentication_type="USERPOOL",
 *     user_name="EMAIL",
 *     first_name="FIRST NAME",
 *     last_name="LAST NAME")
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var example = new Aws.AppStream.User("example", new()
 *     {
 *         AuthenticationType = "USERPOOL",
 *         UserName = "EMAIL",
 *         FirstName = "FIRST NAME",
 *         LastName = "LAST NAME",
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		_, err := appstream.NewUser(ctx, "example", &appstream.UserArgs{
 * 			AuthenticationType: pulumi.String("USERPOOL"),
 * 			UserName:           pulumi.String("EMAIL"),
 * 			FirstName:          pulumi.String("FIRST NAME"),
 * 			LastName:           pulumi.String("LAST NAME"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.User;
 * import com.pulumi.aws.appstream.UserArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var example = new User("example", UserArgs.builder()
 *             .authenticationType("USERPOOL")
 *             .userName("EMAIL")
 *             .firstName("FIRST NAME")
 *             .lastName("LAST NAME")
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   example:
 *     type: aws:appstream:User
 *     properties:
 *       authenticationType: USERPOOL
 *       userName: EMAIL
 *       firstName: FIRST NAME
 *       lastName: LAST NAME
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import `aws_appstream_user` using the `user_name` and `authentication_type` separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:appstream/user:User example UserName/AuthenticationType
 * ```
 * @property authenticationType Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
 * @property enabled Whether the user in the user pool is enabled.
 * @property firstName First name, or given name, of the user.
 * @property lastName Last name, or surname, of the user.
 * @property sendEmailNotification Send an email notification.
 * @property userName Email address of the user.
 * The following arguments are optional:
 */
public data class UserArgs(
    public val authenticationType: Output<String>? = null,
    public val enabled: Output<Boolean>? = null,
    public val firstName: Output<String>? = null,
    public val lastName: Output<String>? = null,
    public val sendEmailNotification: Output<Boolean>? = null,
    public val userName: Output<String>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.UserArgs> {
    override fun toJava(): com.pulumi.aws.appstream.UserArgs =
        com.pulumi.aws.appstream.UserArgs.builder()
            .authenticationType(authenticationType?.applyValue({ args0 -> args0 }))
            .enabled(enabled?.applyValue({ args0 -> args0 }))
            .firstName(firstName?.applyValue({ args0 -> args0 }))
            .lastName(lastName?.applyValue({ args0 -> args0 }))
            .sendEmailNotification(sendEmailNotification?.applyValue({ args0 -> args0 }))
            .userName(userName?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [UserArgs].
 */
@PulumiTagMarker
public class UserArgsBuilder internal constructor() {
    private var authenticationType: Output<String>? = null

    private var enabled: Output<Boolean>? = null

    private var firstName: Output<String>? = null

    private var lastName: Output<String>? = null

    private var sendEmailNotification: Output<Boolean>? = null

    private var userName: Output<String>? = null

    /**
     * @param value Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
     */
    @JvmName("bofllneilphrvwbr")
    public suspend fun authenticationType(`value`: Output<String>) {
        this.authenticationType = value
    }

    /**
     * @param value Whether the user in the user pool is enabled.
     */
    @JvmName("gpofdibecblaintw")
    public suspend fun enabled(`value`: Output<Boolean>) {
        this.enabled = value
    }

    /**
     * @param value First name, or given name, of the user.
     */
    @JvmName("pjclubbawcyfsaoa")
    public suspend fun firstName(`value`: Output<String>) {
        this.firstName = value
    }

    /**
     * @param value Last name, or surname, of the user.
     */
    @JvmName("vwduhuwkjqtqashu")
    public suspend fun lastName(`value`: Output<String>) {
        this.lastName = value
    }

    /**
     * @param value Send an email notification.
     */
    @JvmName("kvtpjnvorawprbtr")
    public suspend fun sendEmailNotification(`value`: Output<Boolean>) {
        this.sendEmailNotification = value
    }

    /**
     * @param value Email address of the user.
     * The following arguments are optional:
     */
    @JvmName("yhschouipsohckyv")
    public suspend fun userName(`value`: Output<String>) {
        this.userName = value
    }

    /**
     * @param value Authentication type for the user. You must specify USERPOOL. Valid values: `API`, `SAML`, `USERPOOL`
     */
    @JvmName("nwjqkykwiriieclt")
    public suspend fun authenticationType(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.authenticationType = mapped
    }

    /**
     * @param value Whether the user in the user pool is enabled.
     */
    @JvmName("ietidjqgakwesieo")
    public suspend fun enabled(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.enabled = mapped
    }

    /**
     * @param value First name, or given name, of the user.
     */
    @JvmName("amennvjoqmqffrgt")
    public suspend fun firstName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.firstName = mapped
    }

    /**
     * @param value Last name, or surname, of the user.
     */
    @JvmName("sphpwmatetpqhlay")
    public suspend fun lastName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.lastName = mapped
    }

    /**
     * @param value Send an email notification.
     */
    @JvmName("njvhsvunbssxntns")
    public suspend fun sendEmailNotification(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.sendEmailNotification = mapped
    }

    /**
     * @param value Email address of the user.
     * The following arguments are optional:
     */
    @JvmName("shxouhhejxdhggsx")
    public suspend fun userName(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.userName = mapped
    }

    internal fun build(): UserArgs = UserArgs(
        authenticationType = authenticationType,
        enabled = enabled,
        firstName = firstName,
        lastName = lastName,
        sendEmailNotification = sendEmailNotification,
        userName = userName,
    )
}
