@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin

import com.pulumi.core.Output
import com.pulumi.kotlin.KotlinCustomResource
import com.pulumi.kotlin.PulumiTagMarker
import com.pulumi.kotlin.ResourceMapper
import com.pulumi.kotlin.options.CustomResourceOptions
import com.pulumi.kotlin.options.CustomResourceOptionsBuilder
import com.pulumi.resources.Resource
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.Unit

/**
 * Builder for [UserStackAssociation].
 */
@PulumiTagMarker
public class UserStackAssociationResourceBuilder internal constructor() {
    public var name: String? = null

    public var args: UserStackAssociationArgs = UserStackAssociationArgs()

    public var opts: CustomResourceOptions = CustomResourceOptions()

    /**
     * @param name The _unique_ name of the resulting resource.
     */
    public fun name(`value`: String) {
        this.name = value
    }

    /**
     * @param block The arguments to use to populate this resource's properties.
     */
    public suspend fun args(block: suspend UserStackAssociationArgsBuilder.() -> Unit) {
        val builder = UserStackAssociationArgsBuilder()
        block(builder)
        this.args = builder.build()
    }

    /**
     * @param block A bag of options that control this resource's behavior.
     */
    public suspend fun opts(block: suspend CustomResourceOptionsBuilder.() -> Unit) {
        this.opts = com.pulumi.kotlin.options.CustomResourceOptions.opts(block)
    }

    internal fun build(): UserStackAssociation {
        val builtJavaResource = com.pulumi.aws.appstream.UserStackAssociation(
            this.name,
            this.args.toJava(),
            this.opts.toJava(),
        )
        return UserStackAssociation(builtJavaResource)
    }
}

/**
 * Manages an AppStream User Stack association.
 * ## Example Usage
 * <!--Start PulumiCodeChooser -->
 * ```typescript
 * import * as pulumi from "@pulumi/pulumi";
 * import * as aws from "@pulumi/aws";
 * const test = new aws.appstream.Stack("test", {name: "STACK NAME"});
 * const testUser = new aws.appstream.User("test", {
 *     authenticationType: "USERPOOL",
 *     userName: "EMAIL",
 * });
 * const testUserStackAssociation = new aws.appstream.UserStackAssociation("test", {
 *     authenticationType: testUser.authenticationType,
 *     stackName: test.name,
 *     userName: testUser.userName,
 * });
 * ```
 * ```python
 * import pulumi
 * import pulumi_aws as aws
 * test = aws.appstream.Stack("test", name="STACK NAME")
 * test_user = aws.appstream.User("test",
 *     authentication_type="USERPOOL",
 *     user_name="EMAIL")
 * test_user_stack_association = aws.appstream.UserStackAssociation("test",
 *     authentication_type=test_user.authentication_type,
 *     stack_name=test.name,
 *     user_name=test_user.user_name)
 * ```
 * ```csharp
 * using System.Collections.Generic;
 * using System.Linq;
 * using Pulumi;
 * using Aws = Pulumi.Aws;
 * return await Deployment.RunAsync(() =>
 * {
 *     var test = new Aws.AppStream.Stack("test", new()
 *     {
 *         Name = "STACK NAME",
 *     });
 *     var testUser = new Aws.AppStream.User("test", new()
 *     {
 *         AuthenticationType = "USERPOOL",
 *         UserName = "EMAIL",
 *     });
 *     var testUserStackAssociation = new Aws.AppStream.UserStackAssociation("test", new()
 *     {
 *         AuthenticationType = testUser.AuthenticationType,
 *         StackName = test.Name,
 *         UserName = testUser.UserName,
 *     });
 * });
 * ```
 * ```go
 * package main
 * import (
 * 	"github.com/pulumi/pulumi-aws/sdk/v6/go/aws/appstream"
 * 	"github.com/pulumi/pulumi/sdk/v3/go/pulumi"
 * )
 * func main() {
 * 	pulumi.Run(func(ctx *pulumi.Context) error {
 * 		test, err := appstream.NewStack(ctx, "test", &appstream.StackArgs{
 * 			Name: pulumi.String("STACK NAME"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		testUser, err := appstream.NewUser(ctx, "test", &appstream.UserArgs{
 * 			AuthenticationType: pulumi.String("USERPOOL"),
 * 			UserName:           pulumi.String("EMAIL"),
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		_, err = appstream.NewUserStackAssociation(ctx, "test", &appstream.UserStackAssociationArgs{
 * 			AuthenticationType: testUser.AuthenticationType,
 * 			StackName:          test.Name,
 * 			UserName:           testUser.UserName,
 * 		})
 * 		if err != nil {
 * 			return err
 * 		}
 * 		return nil
 * 	})
 * }
 * ```
 * ```java
 * package generated_program;
 * import com.pulumi.Context;
 * import com.pulumi.Pulumi;
 * import com.pulumi.core.Output;
 * import com.pulumi.aws.appstream.Stack;
 * import com.pulumi.aws.appstream.StackArgs;
 * import com.pulumi.aws.appstream.User;
 * import com.pulumi.aws.appstream.UserArgs;
 * import com.pulumi.aws.appstream.UserStackAssociation;
 * import com.pulumi.aws.appstream.UserStackAssociationArgs;
 * import java.util.List;
 * import java.util.ArrayList;
 * import java.util.Map;
 * import java.io.File;
 * import java.nio.file.Files;
 * import java.nio.file.Paths;
 * public class App {
 *     public static void main(String[] args) {
 *         Pulumi.run(App::stack);
 *     }
 *     public static void stack(Context ctx) {
 *         var test = new Stack("test", StackArgs.builder()
 *             .name("STACK NAME")
 *             .build());
 *         var testUser = new User("testUser", UserArgs.builder()
 *             .authenticationType("USERPOOL")
 *             .userName("EMAIL")
 *             .build());
 *         var testUserStackAssociation = new UserStackAssociation("testUserStackAssociation", UserStackAssociationArgs.builder()
 *             .authenticationType(testUser.authenticationType())
 *             .stackName(test.name())
 *             .userName(testUser.userName())
 *             .build());
 *     }
 * }
 * ```
 * ```yaml
 * resources:
 *   test:
 *     type: aws:appstream:Stack
 *     properties:
 *       name: STACK NAME
 *   testUser:
 *     type: aws:appstream:User
 *     name: test
 *     properties:
 *       authenticationType: USERPOOL
 *       userName: EMAIL
 *   testUserStackAssociation:
 *     type: aws:appstream:UserStackAssociation
 *     name: test
 *     properties:
 *       authenticationType: ${testUser.authenticationType}
 *       stackName: ${test.name}
 *       userName: ${testUser.userName}
 * ```
 * <!--End PulumiCodeChooser -->
 * ## Import
 * Using `pulumi import`, import AppStream User Stack Association using the `user_name`, `authentication_type`, and `stack_name`, separated by a slash (`/`). For example:
 * ```sh
 * $ pulumi import aws:appstream/userStackAssociation:UserStackAssociation example userName/auhtenticationType/stackName
 * ```
 */
public class UserStackAssociation internal constructor(
    override val javaResource: com.pulumi.aws.appstream.UserStackAssociation,
) : KotlinCustomResource(javaResource, UserStackAssociationMapper) {
    /**
     * Authentication type for the user.
     */
    public val authenticationType: Output<String>
        get() = javaResource.authenticationType().applyValue({ args0 -> args0 })

    /**
     * Whether a welcome email is sent to a user after the user is created in the user pool.
     */
    public val sendEmailNotification: Output<Boolean>?
        get() = javaResource.sendEmailNotification().applyValue({ args0 ->
            args0.map({ args0 ->
                args0
            }).orElse(null)
        })

    /**
     * Name of the stack that is associated with the user.
     */
    public val stackName: Output<String>
        get() = javaResource.stackName().applyValue({ args0 -> args0 })

    /**
     * Email address of the user who is associated with the stack.
     * The following arguments are optional:
     */
    public val userName: Output<String>
        get() = javaResource.userName().applyValue({ args0 -> args0 })
}

public object UserStackAssociationMapper : ResourceMapper<UserStackAssociation> {
    override fun supportsMappingOfType(javaResource: Resource): Boolean =
        com.pulumi.aws.appstream.UserStackAssociation::class == javaResource::class

    override fun map(javaResource: Resource): UserStackAssociation = UserStackAssociation(
        javaResource
            as com.pulumi.aws.appstream.UserStackAssociation,
    )
}

/**
 * @see [UserStackAssociation].
 * @param name The _unique_ name of the resulting resource.
 * @param block Builder for [UserStackAssociation].
 */
public suspend fun userStackAssociation(
    name: String,
    block: suspend UserStackAssociationResourceBuilder.() -> Unit,
): UserStackAssociation {
    val builder = UserStackAssociationResourceBuilder()
    builder.name(name)
    block(builder)
    return builder.build()
}

/**
 * @see [UserStackAssociation].
 * @param name The _unique_ name of the resulting resource.
 */
public fun userStackAssociation(name: String): UserStackAssociation {
    val builder = UserStackAssociationResourceBuilder()
    builder.name(name)
    return builder.build()
}
