@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Int
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 *
 * @property available Number of currently available instances that can be used to stream sessions.
 * @property desiredInstances Desired number of streaming instances.
 * @property desiredSessions Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
 * @property inUse Number of instances in use for streaming.
 * @property running Total number of simultaneous streaming instances that are running.
 */
public data class FleetComputeCapacityArgs(
    public val available: Output<Int>? = null,
    public val desiredInstances: Output<Int>? = null,
    public val desiredSessions: Output<Int>? = null,
    public val inUse: Output<Int>? = null,
    public val running: Output<Int>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs =
        com.pulumi.aws.appstream.inputs.FleetComputeCapacityArgs.builder()
            .available(available?.applyValue({ args0 -> args0 }))
            .desiredInstances(desiredInstances?.applyValue({ args0 -> args0 }))
            .desiredSessions(desiredSessions?.applyValue({ args0 -> args0 }))
            .inUse(inUse?.applyValue({ args0 -> args0 }))
            .running(running?.applyValue({ args0 -> args0 })).build()
}

/**
 * Builder for [FleetComputeCapacityArgs].
 */
@PulumiTagMarker
public class FleetComputeCapacityArgsBuilder internal constructor() {
    private var available: Output<Int>? = null

    private var desiredInstances: Output<Int>? = null

    private var desiredSessions: Output<Int>? = null

    private var inUse: Output<Int>? = null

    private var running: Output<Int>? = null

    /**
     * @param value Number of currently available instances that can be used to stream sessions.
     */
    @JvmName("ybqtvxsvjyieovtr")
    public suspend fun available(`value`: Output<Int>) {
        this.available = value
    }

    /**
     * @param value Desired number of streaming instances.
     */
    @JvmName("xkhcdotunplbldsc")
    public suspend fun desiredInstances(`value`: Output<Int>) {
        this.desiredInstances = value
    }

    /**
     * @param value Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
     */
    @JvmName("jtnxsjqfpaqqfbll")
    public suspend fun desiredSessions(`value`: Output<Int>) {
        this.desiredSessions = value
    }

    /**
     * @param value Number of instances in use for streaming.
     */
    @JvmName("vbkyavoplpiqotlg")
    public suspend fun inUse(`value`: Output<Int>) {
        this.inUse = value
    }

    /**
     * @param value Total number of simultaneous streaming instances that are running.
     */
    @JvmName("dmvwdwuuimbkvkth")
    public suspend fun running(`value`: Output<Int>) {
        this.running = value
    }

    /**
     * @param value Number of currently available instances that can be used to stream sessions.
     */
    @JvmName("vaosxwiunbvlmfed")
    public suspend fun available(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.available = mapped
    }

    /**
     * @param value Desired number of streaming instances.
     */
    @JvmName("ixwqqvlioompfymq")
    public suspend fun desiredInstances(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredInstances = mapped
    }

    /**
     * @param value Desired number of user sessions for a multi-session fleet. This is not allowed for single-session fleets.
     */
    @JvmName("ayhkusgehnvsdnja")
    public suspend fun desiredSessions(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.desiredSessions = mapped
    }

    /**
     * @param value Number of instances in use for streaming.
     */
    @JvmName("bruwcuyntbpacgib")
    public suspend fun inUse(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.inUse = mapped
    }

    /**
     * @param value Total number of simultaneous streaming instances that are running.
     */
    @JvmName("noimyhbgvgxcxtvx")
    public suspend fun running(`value`: Int?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.running = mapped
    }

    internal fun build(): FleetComputeCapacityArgs = FleetComputeCapacityArgs(
        available = available,
        desiredInstances = desiredInstances,
        desiredSessions = desiredSessions,
        inUse = inUse,
        running = running,
    )
}
