@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.FleetVpcConfigArgs.builder
import com.pulumi.core.Output
import com.pulumi.core.Output.of
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.String
import kotlin.Suppress
import kotlin.collections.List
import kotlin.jvm.JvmName

/**
 *
 * @property securityGroupIds Identifiers of the security groups for the fleet or image builder.
 * @property subnetIds Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
 */
public data class FleetVpcConfigArgs(
    public val securityGroupIds: Output<List<String>>? = null,
    public val subnetIds: Output<List<String>>? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.FleetVpcConfigArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.FleetVpcConfigArgs =
        com.pulumi.aws.appstream.inputs.FleetVpcConfigArgs.builder()
            .securityGroupIds(securityGroupIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) }))
            .subnetIds(subnetIds?.applyValue({ args0 -> args0.map({ args0 -> args0 }) })).build()
}

/**
 * Builder for [FleetVpcConfigArgs].
 */
@PulumiTagMarker
public class FleetVpcConfigArgsBuilder internal constructor() {
    private var securityGroupIds: Output<List<String>>? = null

    private var subnetIds: Output<List<String>>? = null

    /**
     * @param value Identifiers of the security groups for the fleet or image builder.
     */
    @JvmName("gwdwpndeeaespavs")
    public suspend fun securityGroupIds(`value`: Output<List<String>>) {
        this.securityGroupIds = value
    }

    @JvmName("oxinhfhawqrmnndx")
    public suspend fun securityGroupIds(vararg values: Output<String>) {
        this.securityGroupIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of the security groups for the fleet or image builder.
     */
    @JvmName("fimlikcykdobnscc")
    public suspend fun securityGroupIds(values: List<Output<String>>) {
        this.securityGroupIds = Output.all(values)
    }

    /**
     * @param value Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
     */
    @JvmName("qpftbsxsvsmbbadp")
    public suspend fun subnetIds(`value`: Output<List<String>>) {
        this.subnetIds = value
    }

    @JvmName("yyjytnaibbxqluia")
    public suspend fun subnetIds(vararg values: Output<String>) {
        this.subnetIds = Output.all(values.asList())
    }

    /**
     * @param values Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
     */
    @JvmName("bowrwxxpnacylthf")
    public suspend fun subnetIds(values: List<Output<String>>) {
        this.subnetIds = Output.all(values)
    }

    /**
     * @param value Identifiers of the security groups for the fleet or image builder.
     */
    @JvmName("efdahrtxrglvyimu")
    public suspend fun securityGroupIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param values Identifiers of the security groups for the fleet or image builder.
     */
    @JvmName("efvivrlwgbmfrhyu")
    public suspend fun securityGroupIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.securityGroupIds = mapped
    }

    /**
     * @param value Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
     */
    @JvmName("kiswekxogcljkrxv")
    public suspend fun subnetIds(`value`: List<String>?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    /**
     * @param values Identifiers of the subnets to which a network interface is attached from the fleet instance or image builder instance.
     */
    @JvmName("iutbvdhhudkpwbqo")
    public suspend fun subnetIds(vararg values: String) {
        val toBeMapped = values.toList()
        val mapped = toBeMapped.let({ args0 -> of(args0) })
        this.subnetIds = mapped
    }

    internal fun build(): FleetVpcConfigArgs = FleetVpcConfigArgs(
        securityGroupIds = securityGroupIds,
        subnetIds = subnetIds,
    )
}
