@file:Suppress("NAME_SHADOWING", "DEPRECATION")

package com.pulumi.aws.appstream.kotlin.inputs

import com.pulumi.aws.appstream.inputs.GetImagePlainArgs.builder
import com.pulumi.kotlin.ConvertibleToJava
import com.pulumi.kotlin.PulumiTagMarker
import kotlin.Boolean
import kotlin.String
import kotlin.Suppress
import kotlin.jvm.JvmName

/**
 * A collection of arguments for invoking getImage.
 * @property arn Arn of the image being searched for. Cannot be used with name_regex or name.
 * @property mostRecent Boolean that if it is set to true and there are multiple images returned the most recent will be returned. If it is set to false and there are multiple images return the datasource will error.
 * @property name Name of the image being searched for. Cannot be used with name_regex or arn.
 * @property nameRegex Regular expression name of the image being searched for. Cannot be used with arn or name.
 * @property type The type of image which must be (PUBLIC, PRIVATE, or SHARED).
 */
public data class GetImagePlainArgs(
    public val arn: String? = null,
    public val mostRecent: Boolean? = null,
    public val name: String? = null,
    public val nameRegex: String? = null,
    public val type: String? = null,
) : ConvertibleToJava<com.pulumi.aws.appstream.inputs.GetImagePlainArgs> {
    override fun toJava(): com.pulumi.aws.appstream.inputs.GetImagePlainArgs =
        com.pulumi.aws.appstream.inputs.GetImagePlainArgs.builder()
            .arn(arn?.let({ args0 -> args0 }))
            .mostRecent(mostRecent?.let({ args0 -> args0 }))
            .name(name?.let({ args0 -> args0 }))
            .nameRegex(nameRegex?.let({ args0 -> args0 }))
            .type(type?.let({ args0 -> args0 })).build()
}

/**
 * Builder for [GetImagePlainArgs].
 */
@PulumiTagMarker
public class GetImagePlainArgsBuilder internal constructor() {
    private var arn: String? = null

    private var mostRecent: Boolean? = null

    private var name: String? = null

    private var nameRegex: String? = null

    private var type: String? = null

    /**
     * @param value Arn of the image being searched for. Cannot be used with name_regex or name.
     */
    @JvmName("xdrqmygnpwheuctv")
    public suspend fun arn(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.arn = mapped
    }

    /**
     * @param value Boolean that if it is set to true and there are multiple images returned the most recent will be returned. If it is set to false and there are multiple images return the datasource will error.
     */
    @JvmName("ubksxwgjocasrmnk")
    public suspend fun mostRecent(`value`: Boolean?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.mostRecent = mapped
    }

    /**
     * @param value Name of the image being searched for. Cannot be used with name_regex or arn.
     */
    @JvmName("qcjhiodglmogdmnx")
    public suspend fun name(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.name = mapped
    }

    /**
     * @param value Regular expression name of the image being searched for. Cannot be used with arn or name.
     */
    @JvmName("xmowgswssifkfvcd")
    public suspend fun nameRegex(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.nameRegex = mapped
    }

    /**
     * @param value The type of image which must be (PUBLIC, PRIVATE, or SHARED).
     */
    @JvmName("tbxopndpjkrlkuxy")
    public suspend fun type(`value`: String?) {
        val toBeMapped = value
        val mapped = toBeMapped?.let({ args0 -> args0 })
        this.type = mapped
    }

    internal fun build(): GetImagePlainArgs = GetImagePlainArgs(
        arn = arn,
        mostRecent = mostRecent,
        name = name,
        nameRegex = nameRegex,
        type = type,
    )
}
